/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import crazywoddman.warium_create.recipe.WariumCreateRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ColoringRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final String baseIngredient;
    public final List<String> itemIngredients;
    public final List<FluidIngredient> fluidIngredients;
    public final String resultItem;

    public ColoringRecipe(ResourceLocation id, String baseIngredient, List<String> itemIngredients, List<FluidIngredient> fluidIngredients, String resultItem) {
        this.id = id;
        this.baseIngredient = baseIngredient;
        this.itemIngredients = itemIngredients != null ? itemIngredients : new ArrayList();
        this.fluidIngredients = fluidIngredients != null ? fluidIngredients : new ArrayList();
        this.resultItem = resultItem;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return WariumCreateRecipeTypes.COLORING.getSerializer();
    }

    public RecipeType<?> m_6671_() {
        return WariumCreateRecipeTypes.COLORING.getType();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122779_();
    }

    public String getBaseIngredientPattern() {
        return this.baseIngredient;
    }

    public List<String> getItemIngredientPatterns() {
        return this.itemIngredients;
    }

    public List<FluidIngredient> getFluidIngredients() {
        return this.fluidIngredients;
    }

    public String getResultItem() {
        return this.resultItem;
    }

    public static class Serializer
    implements RecipeSerializer<ColoringRecipe> {
        public ColoringRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Object baseIngredient = "";
            ArrayList<String> itemIngredients = new ArrayList<String>();
            ArrayList<FluidIngredient> fluidIngredients = new ArrayList<FluidIngredient>();
            if (json.has("ingredients")) {
                JsonArray ingredientsArray = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
                for (int i = 0; i < ingredientsArray.size(); ++i) {
                    JsonElement element = ingredientsArray.get(i);
                    JsonObject ingredientObj = element.getAsJsonObject();
                    if (ingredientObj.has("fluid")) {
                        String fluidPattern = GsonHelper.m_13906_((JsonObject)ingredientObj, (String)"fluid");
                        int amount = GsonHelper.m_13824_((JsonObject)ingredientObj, (String)"amount", (int)1000);
                        fluidIngredients.add(new FluidIngredient(fluidPattern, amount));
                        continue;
                    }
                    Object ingredientPattern = "";
                    if (ingredientObj.has("item")) {
                        ingredientPattern = GsonHelper.m_13906_((JsonObject)ingredientObj, (String)"item");
                    } else if (ingredientObj.has("tag")) {
                        ingredientPattern = "#" + GsonHelper.m_13906_((JsonObject)ingredientObj, (String)"tag");
                    }
                    if (((String)ingredientPattern).isEmpty()) continue;
                    if (i == 0) {
                        baseIngredient = ingredientPattern;
                        continue;
                    }
                    itemIngredients.add((String)ingredientPattern);
                }
            }
            String resultItem = "";
            if (json.has("result")) {
                resultItem = GsonHelper.m_13906_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (String)"item");
            }
            return new ColoringRecipe(recipeId, (String)baseIngredient, itemIngredients, fluidIngredients, resultItem);
        }

        public ColoringRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String baseIngredient = buffer.m_130277_();
            int itemCount = buffer.m_130242_();
            ArrayList<String> itemIngredients = new ArrayList<String>();
            for (int i = 0; i < itemCount; ++i) {
                itemIngredients.add(buffer.m_130277_());
            }
            int fluidCount = buffer.m_130242_();
            ArrayList<FluidIngredient> fluidIngredients = new ArrayList<FluidIngredient>();
            for (int i = 0; i < fluidCount; ++i) {
                String fluidPattern = buffer.m_130277_();
                int amount = buffer.m_130242_();
                fluidIngredients.add(new FluidIngredient(fluidPattern, amount));
            }
            String resultItem = buffer.m_130277_();
            return new ColoringRecipe(recipeId, baseIngredient, itemIngredients, fluidIngredients, resultItem);
        }

        public void toNetwork(FriendlyByteBuf buffer, ColoringRecipe recipe) {
            buffer.m_130070_(recipe.baseIngredient);
            buffer.m_130130_(recipe.itemIngredients.size());
            for (String pattern : recipe.itemIngredients) {
                buffer.m_130070_(pattern);
            }
            buffer.m_130130_(recipe.fluidIngredients.size());
            for (FluidIngredient fluidIngredient : recipe.fluidIngredients) {
                buffer.m_130070_(fluidIngredient.fluidPattern);
                buffer.m_130130_(fluidIngredient.amount);
            }
            buffer.m_130070_(recipe.resultItem);
        }
    }

    public static class FluidIngredient {
        private final String fluidPattern;
        private final int amount;

        public FluidIngredient(String fluidPattern, int amount) {
            this.fluidPattern = fluidPattern;
            this.amount = amount;
        }

        public String getFluidPattern() {
            return this.fluidPattern;
        }

        public int getAmount() {
            return this.amount;
        }

        public FluidStack createFluidStack(String color) {
            try {
                String processedPattern = this.fluidPattern.replace("{color}", color);
                ResourceLocation fluidLocation = ResourceLocation.parse((String)processedPattern);
                if (ForgeRegistries.FLUIDS.containsKey(fluidLocation)) {
                    return new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidLocation), this.amount);
                }
            }
            catch (Exception e) {
                System.err.println("Failed to create fluid stack from pattern: " + this.fluidPattern + " with color: " + color);
            }
            return FluidStack.EMPTY;
        }
    }
}

