/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final Server SERVER = new Server(builder);
    public static final ForgeConfigSpec SERVER_SPEC = builder.build();

    public static class Server {
        public final ForgeConfigSpec.IntValue energyToFErate;
        public final ForgeConfigSpec.IntValue defaultStress;
        public final ForgeConfigSpec.IntValue defaultSpeed;
        public final ForgeConfigSpec.IntValue minThrottle;
        public final ForgeConfigSpec.IntValue maxThrottle;
        public final ForgeConfigSpec.BooleanValue converterSpeedControl;
        public final ForgeConfigSpec.BooleanValue throttleToRotationDirection;
        public final ForgeConfigSpec.ConfigValue<BlazeBurnerBlock.HeatLevel> fireboxHeat;
        public final ForgeConfigSpec.ConfigValue<BlazeBurnerBlock.HeatLevel> oilFireboxHeat;
        public final ForgeConfigSpec.ConfigValue<BlazeBurnerBlock.HeatLevel> electricFireboxHeat;
        public final ForgeConfigSpec.IntValue kineticConverterReponse;
        public final ForgeConfigSpec.DoubleValue enginePower;
        public final ForgeConfigSpec.DoubleValue turbinePower;

        public Server(ForgeConfigSpec.Builder builder) {
            this.energyToFErate = builder.comment("How much ForgeEnergy = 1 Warium Energy unit. ").comment("This affects:").comment("  Energy Battery and Power Reactor FE capacity (8000 * this number)").comment("  Rotation Generator FE output ").comment("  FE needed for Electric Motor to work").defineInRange("energyToForgeEnergyRate", 100, 1, Integer.MAX_VALUE);
            this.defaultStress = builder.comment("How many Stress Untis will be equivalent to 1 Kinetic Power unit").defineInRange("kineticToStressRate", 40, 1, Integer.MAX_VALUE);
            this.defaultSpeed = builder.comment("What Rotation Speed is equivalent to 1 Kinetic Power unit").defineInRange("kineticToSpeedRate", 2, 1, 5);
            this.minThrottle = builder.comment("Minimal throttle value that can be set using Control Seat").defineInRange("minThrottle", -10, Integer.MIN_VALUE, -1);
            this.maxThrottle = builder.comment("Maximum throttle value that can be set using Control Seat").defineInRange("maxThrottle", 10, 1, Integer.MAX_VALUE);
            this.converterSpeedControl = builder.comment("Whether Kinetic Converter value box allows to select generating speed").define("kineticConverterSpeedControl", false);
            this.throttleToRotationDirection = builder.comment("Whether negative throttle values should reverse rotation direction").define("throttleToRotationDirection", false);
            this.fireboxHeat = builder.comment("Blaze Burner type heat level for fireboxes").comment("Allowed values are KINDLED or SEETHING").define("fireboxHeatLevel", (Object)BlazeBurnerBlock.HeatLevel.KINDLED, value -> value instanceof BlazeBurnerBlock.HeatLevel && (value.equals(BlazeBurnerBlock.HeatLevel.KINDLED) || value.equals(BlazeBurnerBlock.HeatLevel.SEETHING)));
            this.oilFireboxHeat = builder.define("keroseneFireboxHeatLevel", (Object)BlazeBurnerBlock.HeatLevel.SEETHING, value -> value instanceof BlazeBurnerBlock.HeatLevel && (value.equals(BlazeBurnerBlock.HeatLevel.KINDLED) || value.equals(BlazeBurnerBlock.HeatLevel.SEETHING)));
            this.electricFireboxHeat = builder.define("electricFireboxHeatLevel", (Object)BlazeBurnerBlock.HeatLevel.SEETHING, value -> value instanceof BlazeBurnerBlock.HeatLevel && (value.equals(BlazeBurnerBlock.HeatLevel.KINDLED) || value.equals(BlazeBurnerBlock.HeatLevel.SEETHING)));
            this.kineticConverterReponse = builder.comment("Tick-measured Kinetic Converter response delay when changing throttle").comment("WARNING: lowering this value may cause shafts to break when changing throttle too fast").defineInRange("kineticConverterReponse", 8, 0, 40);
            this.enginePower = builder.comment("Combution engines KineticPower output").defineInRange("enginesPower", 50.0, 0.0, Double.MAX_VALUE);
            this.turbinePower = builder.comment("Jet Turbine KineticPower output").defineInRange("turbinePower", 51.0, 0.0, Double.MAX_VALUE);
        }
    }
}

