/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create.block.converter;

import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import crazywoddman.warium_create.Config;
import crazywoddman.warium_create.util.WariumCreateUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ConverterOutBlockEntity
extends SpeedGaugeBlockEntity {
    private final int defaultStress;
    private final int defaultSpeed;
    private final int maxThrottle;
    private int lastThrottle;

    public ConverterOutBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.defaultStress = (Integer)Config.SERVER.defaultStress.get();
        this.defaultSpeed = (Integer)Config.SERVER.defaultSpeed.get();
        this.maxThrottle = (Integer)Config.SERVER.maxThrottle.get();
    }

    private void updateKineticPower() {
        this.getPersistentData().m_128347_("KineticPower", (double)Math.round(Math.abs(this.getSpeed()) / (float)this.defaultSpeed / (float)this.maxThrottle * (float)this.lastThrottle * 10.0f) / 10.0);
        this.sendData();
    }

    private void updateDialTarget() {
        this.dialTarget = ConverterOutBlockEntity.getDialTarget((float)(this.getSpeed() / (float)this.maxThrottle * (float)this.lastThrottle));
    }

    public void tick() {
        super.tick();
        int throttle = Math.abs(WariumCreateUtil.getThrottle((BlockEntity)this, this.maxThrottle));
        if (this.lastThrottle != throttle) {
            this.lastThrottle = throttle;
            if (this.f_58857_.f_46443_) {
                return;
            }
            KineticNetwork network = this.getOrCreateNetwork();
            if (network != null) {
                network.updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            }
            this.dialTarget = ConverterOutBlockEntity.getDialTarget((float)(this.getSpeed() / (float)this.maxThrottle * (float)throttle));
            this.updateDialTarget();
            this.updateKineticPower();
        }
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateDialTarget();
        this.color = Color.mixColors((int)IRotate.SpeedLevel.of((float)this.speed).getColor(), (int)0xFFFFFF, (float)0.25f);
        this.updateKineticPower();
        this.m_6596_();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)this.defaultStress / (float)this.defaultSpeed / (float)this.maxThrottle * (float)this.lastThrottle;
        return impact;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"gui.gauge.info_header", (Object[])new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip);
        Lang.translate((String)"gui.speedometer.title", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        IRotate.SpeedLevel.getFormattedSpeedText((float)(this.getSpeed() / (float)this.maxThrottle * (float)this.lastThrottle), (boolean)this.overStressed).forGoggles(tooltip);
        this.addStressImpactStats(tooltip, this.calculateStressApplied());
        return true;
    }
}

