/*
 * Decompiled with CFR 0.152.
 */
package me.zcraft.tc.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.zcraft.tc.TritiumCommon;

public class ConfigParser {
    public final Map<String, String> configValues = new HashMap<String, String>();
    private final Path configPath;
    private long lastLoadTime = 0L;
    private String currentSection = "";

    public ConfigParser(Path configPath) {
        this.configPath = configPath;
        this.load();
    }

    public void load() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            TritiumCommon.LOG.warn("Config file not found: {}", (Object)this.configPath);
            return;
        }
        try {
            this.configValues.clear();
            this.currentSection = "";
            Files.lines(this.configPath).forEach(line -> {
                String trimmed = line.trim();
                if (trimmed.startsWith("#") || trimmed.isEmpty()) {
                    return;
                }
                if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
                    this.currentSection = trimmed.substring(1, trimmed.length() - 1).trim();
                    return;
                }
                String[] parts = line.split("=", 2);
                if (parts.length == 2) {
                    String fullKey;
                    String key = parts[0].trim();
                    String value = parts[1].trim();
                    String string = fullKey = this.currentSection.isEmpty() ? key : this.currentSection + "." + key;
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    this.configValues.put(fullKey, value);
                }
            });
            this.lastLoadTime = System.currentTimeMillis();
            TritiumCommon.LOG.debug("Loaded {} config values from: {}", (Object)this.configValues.size(), (Object)this.configPath);
        }
        catch (IOException e) {
            TritiumCommon.LOG.error("Failed to load config file: {}", (Object)this.configPath, (Object)e);
        }
    }

    public Supplier<Boolean> getBoolean(String key, boolean defaultValue) {
        return () -> {
            String value = this.configValues.get(key);
            if (value == null) {
                return defaultValue;
            }
            return (value = value.toLowerCase().trim()).equals("true") || value.equals("t") || value.equals("1") || value.equals("yes") || value.equals("y");
        };
    }

    public Supplier<Integer> getInt(String key, int defaultValue) {
        return () -> {
            String value = this.configValues.get(key);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                TritiumCommon.LOG.warn("Invalid integer value '{}' for key '{}', using default: {}", new Object[]{value, key, defaultValue});
                return defaultValue;
            }
        };
    }

    public Supplier<Long> getLong(String key, long defaultValue) {
        return () -> {
            String value = this.configValues.get(key);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException e) {
                TritiumCommon.LOG.warn("Invalid long value '{}' for key '{}', using default: {}", new Object[]{value, key, defaultValue});
                return defaultValue;
            }
        };
    }

    public Supplier<String> getString(String key, String defaultValue) {
        return () -> {
            String value = this.configValues.get(key);
            return value != null ? value.trim() : defaultValue;
        };
    }

    public Supplier<Double> getDouble(String key, double defaultValue) {
        return () -> {
            String value = this.configValues.get(key);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Double.parseDouble(value.trim());
            }
            catch (NumberFormatException e) {
                TritiumCommon.LOG.warn("Invalid double value '{}' for key '{}', using default: {}", new Object[]{value, key, defaultValue});
                return defaultValue;
            }
        };
    }

    public Supplier<Enum> getEnum(String key, Enum defaultValue) {
        return () -> {
            String value = this.configValues.get(key);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Enum.valueOf(defaultValue.getClass(), value.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                TritiumCommon.LOG.warn("Invalid enum value '{}' for key '{}', using default: {}", new Object[]{value, key, defaultValue});
                return defaultValue;
            }
        };
    }

    public Supplier<List<String>> getStringList(String key, List<String> defaultValue) {
        return () -> {
            String value = this.configValues.get(key);
            if (value == null) {
                return defaultValue;
            }
            try {
                if (value.startsWith("[") && value.endsWith("]")) {
                    String[] items;
                    String arrayContent = value.substring(1, value.length() - 1).trim();
                    if (arrayContent.isEmpty()) {
                        return new ArrayList();
                    }
                    ArrayList<String> result = new ArrayList<String>();
                    for (String item : items = arrayContent.split(",")) {
                        String trimmedItem = item.trim();
                        if (trimmedItem.startsWith("\"") && trimmedItem.endsWith("\"")) {
                            trimmedItem = trimmedItem.substring(1, trimmedItem.length() - 1);
                        }
                        result.add(trimmedItem);
                    }
                    return result;
                }
                return Collections.singletonList(value.trim());
            }
            catch (Exception e) {
                TritiumCommon.LOG.warn("Invalid list value '{}' for key '{}', using default: {}", new Object[]{value, key, defaultValue});
                return defaultValue;
            }
        };
    }

    public long getLastLoadTime() {
        return this.lastLoadTime;
    }

    public boolean hasKey(String key) {
        return this.configValues.containsKey(key);
    }
}

