/*
 * Decompiled with CFR 0.152.
 */
package me.zcraft.tc.config.watcher;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.zcraft.tc.TritiumCommon;

public class ConfigFileWatcher {
    private final Path configPath;
    private final Runnable changeCallback;
    private WatchService watchService;
    private ScheduledExecutorService executor;
    private long lastModified;

    public ConfigFileWatcher(Path configPath, Runnable changeCallback) {
        this.configPath = configPath;
        this.changeCallback = changeCallback;
        this.lastModified = this.getLastModified();
    }

    public void start() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            Path parentDir = this.configPath.getParent();
            parentDir.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            this.executor = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "Tritium-Config-Watcher");
                t.setDaemon(true);
                return t;
            });
            this.executor.scheduleWithFixedDelay(this::checkChanges, 2L, 2L, TimeUnit.SECONDS);
            TritiumCommon.LOG.debug("Started config file watcher for: {}", (Object)this.configPath);
        }
        catch (IOException e) {
            TritiumCommon.LOG.error("Failed to start config file watcher", (Throwable)e);
        }
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                TritiumCommon.LOG.error("Error closing watch service", (Throwable)e);
            }
        }
    }

    private void checkChanges() {
        try {
            long currentModified = this.getLastModified();
            if (currentModified > this.lastModified) {
                this.lastModified = currentModified;
                this.changeCallback.run();
            }
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Error checking config file changes", (Throwable)e);
        }
    }

    private long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.configPath, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

