/*
 * Decompiled with CFR 0.152.
 */
package me.zcraft.tc.config;

import java.util.function.Supplier;

public class ConfigValue<T>
implements Supplier<T> {
    private final Supplier<T> valueSupplier;
    private final long cacheDuration;
    private final Object lock = new Object();
    private T cachedValue;
    private long lastUpdateTime;

    public ConfigValue(Supplier<T> valueSupplier) {
        this(valueSupplier, 3000L);
    }

    public ConfigValue(Supplier<T> valueSupplier, long cacheDurationMs) {
        this.valueSupplier = valueSupplier;
        this.cacheDuration = cacheDurationMs;
        this.cachedValue = valueSupplier.get();
        this.lastUpdateTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > this.cacheDuration) {
            Object object = this.lock;
            synchronized (object) {
                if (currentTime - this.lastUpdateTime > this.cacheDuration) {
                    this.cachedValue = this.valueSupplier.get();
                    this.lastUpdateTime = currentTime;
                }
            }
        }
        return this.cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.lock;
        synchronized (object) {
            this.cachedValue = this.valueSupplier.get();
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    public T getRaw() {
        return this.valueSupplier.get();
    }

    public long getCacheAge() {
        return System.currentTimeMillis() - this.lastUpdateTime;
    }
}

