/*
 * Decompiled with CFR 0.152.
 */
package imc.client;

import imc.common.EntityHellHound;
import imc.common.EntityWildChicken;
import imc.common.EntityWildCow;
import imc.common.EntityWildPig;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBasicCreature
extends RenderLiving<EntityLiving> {
    private static final ResourceLocation textureWildCow = new ResourceLocation("imc:textures/entities/cow_wild.png");
    private static final ResourceLocation textureWildPig = new ResourceLocation("imc:textures/entities/pig_wild.png");
    private static final ResourceLocation textureWildChicken = new ResourceLocation("imc:textures/entities/chicken_wild.png");
    private static final ResourceLocation textureHellHound = new ResourceLocation("imc:textures/entities/hell_hound.png");
    private static final ResourceLocation textureHellHoundTamed = new ResourceLocation("imc:textures/entities/hell_hound_tamed.png");

    public RenderBasicCreature(RenderManager renderManager, ModelBase modelBase, float f) {
        super(renderManager, modelBase, f);
    }

    protected float handleChickenRotationFloat(EntityChicken par1EntityChicken, float par2) {
        float f1 = par1EntityChicken.field_70888_h + (par1EntityChicken.field_70886_e - par1EntityChicken.field_70888_h) * par2;
        float f2 = par1EntityChicken.field_70884_g + (par1EntityChicken.field_70883_f - par1EntityChicken.field_70884_g) * par2;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected float handleRotationFloat(EntityLiving entity, float par2) {
        if (entity instanceof EntityWildChicken) {
            return this.handleChickenRotationFloat((EntityChicken)entity, par2);
        }
        if (entity instanceof EntityHellHound) {
            return ((EntityHellHound)entity).getTailRotation();
        }
        return super.func_77044_a((EntityLivingBase)entity, par2);
    }

    protected ResourceLocation getEntityTexture(EntityLiving entity) {
        if (entity.getClass() == EntityWildCow.class) {
            return textureWildCow;
        }
        if (entity.getClass() == EntityWildPig.class) {
            return textureWildPig;
        }
        if (entity.getClass() == EntityHellHound.class) {
            return ((EntityHellHound)entity).func_70909_n() ? textureHellHoundTamed : textureHellHound;
        }
        return textureWildChicken;
    }
}

