/*
 * Decompiled with CFR 0.152.
 */
package imc.common;

import imc.common.EntityAIHellHoundBeg;
import imc.common.EntityAIHellHoundNearestAttackablePlayer;
import imc.common.IMC;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHellHound
extends EntityTameable {
    private static final DataParameter<Float> HEALTH = EntityDataManager.func_187226_a(EntityHellHound.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> BEGGING = EntityDataManager.func_187226_a(EntityHellHound.class, (DataSerializer)DataSerializers.field_187198_h);
    private float headRotationCourse;
    private float headRotationCourseOld;

    public EntityHellHound(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.8f);
        this.field_70728_aV = 10;
        this.field_70178_ae = true;
        this.field_175506_bl = Blocks.field_150424_aL;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIHellHoundBeg(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHellHoundNearestAttackablePlayer(this));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(HEALTH, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEALTH, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(BEGGING, (Object)false);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    public int func_70627_aG() {
        return 200;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(HEALTH)).floatValue() < 10.0f && this.field_70146_Z.nextInt(3) == 0 ? SoundEvents.field_187871_gL : SoundEvents.field_187861_gG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return IMC.sound_hellhound_hit;
    }

    protected SoundEvent func_184615_bR() {
        return IMC.sound_hellhound_death;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && super.func_70601_bi();
    }

    protected void func_70628_a(boolean b, int fortuneLevel) {
        if (fortuneLevel >= 0) {
            int i;
            for (i = Math.min(fortuneLevel, 1) + this.field_70146_Z.nextInt(2 + fortuneLevel); i > 0; --i) {
                this.func_145779_a(Items.field_151059_bz, 1);
            }
            for (i = Math.min(fortuneLevel, 1) + this.field_70146_Z.nextInt(3 + fortuneLevel); i > 0; --i) {
                this.func_145779_a(Items.field_151114_aO, 1);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse += ((this.isBegging() ? 1.0f : 0.0f) - this.headRotationCourse) * 0.4f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 3 == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float f) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * f) * 0.15f * (float)Math.PI;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
            entityIn.func_70015_d(3);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        IAttributeInstance damage = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (damage != null) {
            damage.func_111128_a(tamed ? 6.0 : 4.0);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184614_ca();
        if (this.func_70909_n()) {
            ItemFood itemfood;
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemFood && (itemfood = (ItemFood)itemstack.func_77973_b()).func_77845_h() && (double)((Float)this.field_70180_af.func_187225_a(HEALTH)).floatValue() < this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b()) {
                this.func_70691_i((float)itemfood.func_150905_g(itemstack) * 1.5f);
                itemstack.func_190920_e(itemstack.func_190916_E() - 1);
                if (!player.field_71075_bZ.field_75098_d && itemstack.func_190916_E() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (itemstack != null && itemstack.func_77973_b() == IMC.item_black_bone) {
            itemstack.func_190920_e(itemstack.func_190916_E() - 1);
            if (!player.field_71075_bZ.field_75098_d && itemstack.func_190916_E() <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
                    this.func_184754_b(player.func_110124_au());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.func_70909_n() ? (0.55f - (20.0f - ((Float)this.field_70180_af.func_187225_a(HEALTH)).floatValue()) * 0.01f) * (float)Math.PI : 1.5393804f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return IMC.hell_hounds_breeding && stack != null && stack.func_77973_b() == IMC.item_black_bone;
    }

    public EntityHellHound createChild(EntityAgeable ageable) {
        EntityHellHound hound = new EntityHellHound(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            hound.func_184754_b(uuid);
            hound.func_70903_f(true);
        }
        return hound;
    }

    public void setBegging(boolean beg) {
        this.field_70180_af.func_187227_b(BEGGING, (Object)beg);
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this || !this.func_70909_n() || otherAnimal.getClass() != EntityHellHound.class) {
            return false;
        }
        EntityHellHound hound = (EntityHellHound)otherAnimal;
        return hound.func_70909_n() && !hound.func_70906_o() && this.func_70880_s() && hound.func_70880_s();
    }

    public boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(BEGGING);
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n() && this.field_70173_aa > 2400;
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (target instanceof EntityCreeper || target instanceof EntityGhast) {
            return false;
        }
        if (target instanceof EntityWolf && ((EntityWolf)target).func_70909_n() && ((EntityWolf)target).func_70902_q() == owner || target instanceof EntityHellHound && ((EntityHellHound)target).func_70909_n() && ((EntityHellHound)target).func_70902_q() == owner) {
            return false;
        }
        if (target instanceof EntityPlayer && owner instanceof EntityPlayer && ((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
            return false;
        }
        return !(target instanceof EntityHorse) || !((EntityHorse)target).func_110248_bS();
    }
}

