/*
 * Decompiled with CFR 0.152.
 */
package imc.common;

import imc.common.EntityWildCow;
import imc.common.IMC;
import imc.common.RegistryHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class ItemWoodenBucket
extends ItemBucket {
    private Block isFull;

    public ItemWoodenBucket(String name, Block containedBlock) {
        super(containedBlock);
        this.setRegistryName(name);
        this.func_77655_b("imc." + this.getRegistryName().func_110623_a());
        RegistryHandler.ITEMS_TO_REGISTER.add((Item)this);
        this.func_77637_a((CreativeTabs)(IMC.wooden_bucket ? CreativeTabs.field_78026_f : null));
        this.isFull = containedBlock;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        boolean flag = this.isFull == Blocks.field_150350_a;
        RayTraceResult rayTraceResult = this.func_77621_a(worldIn, playerIn, flag);
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (rayTraceResult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)playerIn, (World)worldIn, (ItemStack)itemStackIn, (RayTraceResult)rayTraceResult);
        if (ret != null) {
            return ret;
        }
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = rayTraceResult.func_178782_a();
            if (!worldIn.func_175660_a(playerIn, blockpos)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
            if (flag) {
                if (!playerIn.func_175151_a(blockpos.func_177972_a(rayTraceResult.field_178784_b), rayTraceResult.field_178784_b, itemStackIn)) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
                }
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                Material material = iblockstate.func_185904_a();
                if (material == Material.field_151586_h && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                    worldIn.func_175698_g(blockpos);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemWoodenBucket.fillBucket(itemStackIn, playerIn, IMC.item_wooden_bucket_water));
                }
            } else {
                if (this.isFull == Blocks.field_150350_a) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(IMC.item_wooden_bucket));
                }
                BlockPos blockpos1 = blockpos.func_177972_a(rayTraceResult.field_178784_b);
                if (playerIn.func_175151_a(blockpos1, rayTraceResult.field_178784_b, itemStackIn) && this.func_180616_a(playerIn, worldIn, blockpos1) && !playerIn.field_71075_bZ.field_75098_d) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(IMC.item_wooden_bucket));
                }
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    private static ItemStack fillBucket(ItemStack emptyBuckets, EntityPlayer player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        emptyBuckets.func_190920_e(emptyBuckets.func_190916_E() - 1);
        if (emptyBuckets.func_190916_E() <= 0) {
            return new ItemStack(fullBucket);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack(fullBucket))) {
            player.func_71019_a(new ItemStack(fullBucket, 1, 0), false);
        }
        return emptyBuckets;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target instanceof EntityCow && !(target instanceof EntityWildCow) && stack.func_77973_b() == IMC.item_wooden_bucket && !player.field_71075_bZ.field_75098_d) {
            if (stack.func_190916_E() <= 1) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(IMC.item_wooden_bucket_milk));
            } else {
                stack.func_190920_e(stack.func_190916_E() - 1);
                if (!player.field_71071_by.func_70441_a(new ItemStack(IMC.item_wooden_bucket_milk))) {
                    player.func_71019_a(new ItemStack(IMC.item_wooden_bucket_milk, 1, 0), false);
                }
            }
            return true;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, 1);
    }
}

