/*
 * Decompiled with CFR 0.152.
 */
package imc.common;

import com.google.common.collect.Sets;
import imc.common.IMC;
import imc.common.PacketMiningExplosion;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MiningExplosion
extends Explosion {
    private World world;
    private final float explosionSize;
    private final double explosionX;
    private final double explosionY;
    private final double explosionZ;
    private final Entity exploder;

    public MiningExplosion(World par1World, Entity entity, double x, double y, double z, float f) {
        super(par1World, entity, x, y, z, f, false, true);
        this.world = par1World;
        this.exploder = entity;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.explosionSize = f;
    }

    public void func_77278_a() {
        int k;
        int j;
        HashSet hashset = Sets.newHashSet();
        for (int i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                for (k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d0 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.explosionX;
                    double d6 = this.explosionY;
                    double d8 = this.explosionZ;
                    for (float f = this.explosionSize * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        IBlockState iblockstate = this.world.func_180495_p(blockpos);
                        if (iblockstate.func_185904_a() != Material.field_151579_a) {
                            float f2 = this.exploder != null ? this.exploder.func_180428_a((Explosion)this, this.world, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.world, blockpos, (Entity)null, (Explosion)this);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, this.world, blockpos, iblockstate, f))) {
                            hashset.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.func_180343_e().addAll(hashset);
        float f3 = this.explosionSize * 2.0f;
        j = MathHelper.func_76128_c((double)(this.explosionX - (double)f3 - 1.0));
        k = MathHelper.func_76128_c((double)(this.explosionX + (double)f3 + 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.explosionY - (double)f3 - 1.0));
        int l = MathHelper.func_76128_c((double)(this.explosionY + (double)f3 + 1.0));
        int k1 = MathHelper.func_76128_c((double)(this.explosionZ - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.explosionZ + (double)f3 + 1.0));
        List list = this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)j, (double)j1, (double)k1, (double)k, (double)l, (double)i1));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)f3);
        Vec3d vec3 = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
        for (int l1 = 0; l1 < list.size(); ++l1) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(l1);
            if (entity instanceof EntityItem || entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.explosionX) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.explosionY) * d7 + (d9 = entity.field_70161_v - this.explosionZ) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = this.world.func_72842_a(vec3, entity.func_174813_aQ());
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            double d11 = 1.0;
            if (entity instanceof EntityLivingBase) {
                d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
            }
            entity.field_70159_w += d5 * d11;
            entity.field_70181_x += d7 * d11;
            entity.field_70179_y += d9 * d11;
            if (!(entity instanceof EntityPlayer)) continue;
            this.func_77277_b().put((EntityPlayer)entity, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        this.world.func_184148_a((EntityPlayer)null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), this.explosionX, this.explosionY, this.explosionZ, 64.0);
        IMC.packetChannel.sendToAllAround((IMessage)new PacketMiningExplosion(this.explosionX, this.explosionY, this.explosionZ), point);
        if (this.explosionSize >= 2.0f) {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        }
        for (BlockPos blockpos : this.func_180343_e()) {
            Block block = this.world.func_180495_p(blockpos).func_177230_c();
            if (spawnParticles) {
                double d0 = (float)blockpos.func_177958_n() + this.world.field_73012_v.nextFloat();
                double d1 = (float)blockpos.func_177956_o() + this.world.field_73012_v.nextFloat();
                double d2 = (float)blockpos.func_177952_p() + this.world.field_73012_v.nextFloat();
                double d3 = d0 - this.explosionX;
                double d4 = d1 - this.explosionY;
                double d5 = d2 - this.explosionZ;
                double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                this.world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.explosionX * 1.0) / 2.0, (d1 + this.explosionY * 1.0) / 2.0, (d2 + this.explosionZ * 1.0) / 2.0, d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                this.world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
            }
            if (this.world.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a) continue;
            if (block.func_149659_a((Explosion)this)) {
                block.func_180653_a(this.world, blockpos, this.world.func_180495_p(blockpos), 1.0f, 0);
            }
            block.onBlockExploded(this.world, blockpos, (Explosion)this);
        }
    }
}

