/*
 * Decompiled with CFR 0.152.
 */
package imc.common;

import imc.common.BlockColoredFlowerPot;
import imc.common.BlockIMCDoubleSlab;
import imc.common.IMC;
import imc.common.ItemColoredFlowerPot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.RegistryManager;

public class RegistryHandler {
    public static final List<Block> BLOCKS_TO_REGISTER = new ArrayList<Block>();
    public static final List<Item> ITEMS_TO_REGISTER = new ArrayList<Item>();
    public static final List<SoundEvent> SOUNDS_TO_REGISTER = new ArrayList<SoundEvent>();
    public static final List<IRecipe> RECIPES_TO_REGISTER = new ArrayList<IRecipe>();
    public static final List<Enchantment> ENCHANTMENTS_TO_REGISTER = new ArrayList<Enchantment>();

    @SubscribeEvent
    public void onBlockRegistry(RegistryEvent.Register<Block> event) {
        for (Block block : BLOCKS_TO_REGISTER) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public void onItemRegistry(RegistryEvent.Register<Item> event) {
        for (Block block : BLOCKS_TO_REGISTER) {
            if (block instanceof BlockContainer) continue;
            Item item = (Item)new ItemBlock(block).setRegistryName(block.getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_TO_REGISTER) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        OreDictionary.registerOre((String)"ingotAdamantium", (ItemStack)new ItemStack(IMC.item_adamantium_ingot));
        OreDictionary.registerOre((String)"oreAdamantium", (ItemStack)new ItemStack(IMC.block_adamantium_ore));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCraftingRegistry(RegistryEvent.Register<IRecipe> event) {
        ArrayList<ResourceLocation> RECIPES_TO_REMOVE = new ArrayList<ResourceLocation>();
        if (IMC.items_combining_preserves_enchantments) {
            RECIPES_TO_REMOVE.add(new ResourceLocation("minecraft", "repairitem"));
        }
        if (IMC.disable_wooden_tools_recipes) {
            for (IRecipe recipe : CraftingManager.field_193380_a) {
                Item item;
                ItemStack output = recipe.func_77571_b();
                if (output == null || (item = output.func_77973_b()) != Items.field_151041_m && item != Items.field_151017_I && (!(item instanceof ItemTool) || ((ItemTool)item).func_77861_e() != Item.ToolMaterial.WOOD.name())) continue;
                RECIPES_TO_REMOVE.add(recipe.getRegistryName());
            }
        }
        IForgeRegistryModifiable reg = (IForgeRegistryModifiable)RegistryManager.ACTIVE.getRegistry(IRecipe.class);
        for (ResourceLocation rl : RECIPES_TO_REMOVE) {
            reg.remove(rl);
        }
        for (ResourceLocation rl : RECIPES_TO_REMOVE) {
            event.getRegistry().register((IForgeRegistryEntry)new DummyRecipe().setRegistryName(rl));
        }
        for (IRecipe recipe : RECIPES_TO_REGISTER) {
            event.getRegistry().register((IForgeRegistryEntry)recipe);
        }
    }

    @SubscribeEvent
    public void onSoundRegistry(RegistryEvent.Register<SoundEvent> event) {
        for (SoundEvent sound : SOUNDS_TO_REGISTER) {
            event.getRegistry().register((IForgeRegistryEntry)sound);
        }
    }

    @SubscribeEvent
    public void onEnchantmentRegistry(RegistryEvent.Register<Enchantment> event) {
        for (Enchantment enchantment : ENCHANTMENTS_TO_REGISTER) {
            event.getRegistry().register((IForgeRegistryEntry)enchantment);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerAllModels(ModelRegistryEvent event) {
        for (Item item : ITEMS_TO_REGISTER) {
            if (item == null || item == Items.field_190931_a) continue;
            if (item.func_77614_k()) {
                int i;
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(null, list);
                if (item instanceof ItemColoredFlowerPot) {
                    for (i = 0; i < list.size(); ++i) {
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumDyeColor.func_176766_a((int)i).func_176610_l(), "inventory"));
                    }
                    continue;
                }
                for (i = 0; i < list.size(); ++i) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
        for (Block block : BLOCKS_TO_REGISTER) {
            Item item;
            if (block == null || block == Blocks.field_150350_a || block instanceof BlockIMCDoubleSlab || block instanceof BlockColoredFlowerPot || (item = Item.func_150898_a((Block)block)) == null || item == Items.field_190931_a) continue;
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
        }
    }

    private static class DummyRecipe
    implements IRecipe {
        private static ItemStack result = new ItemStack(Items.field_151045_i, 64);
        private ResourceLocation name;

        private DummyRecipe() {
        }

        public IRecipe setRegistryName(ResourceLocation name) {
            this.name = name;
            return this;
        }

        public ResourceLocation getRegistryName() {
            return this.name;
        }

        public Class<IRecipe> getRegistryType() {
            return IRecipe.class;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            return false;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            return result;
        }

        public boolean func_194133_a(int width, int height) {
            return false;
        }

        public ItemStack func_77571_b() {
            return result;
        }

        public boolean func_192399_d() {
            return true;
        }
    }
}

