/*
 * Decompiled with CFR 0.152.
 */
package imc.common.recipes;

import com.google.gson.JsonObject;
import imc.common.IMC;
import imc.common.recipes.RecipeIMCEnchantedBooks;
import imc.common.recipes.RecipePresents;
import imc.common.recipes.RecipeRepairEnchantedItems;
import java.lang.reflect.Field;
import java.util.function.BooleanSupplier;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class Factories {

    public static class ConditionalConfigFactory
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            try {
                String configName = JsonUtils.func_151200_h((JsonObject)json, (String)"key");
                Field configField = IMC.class.getField(configName);
                Boolean result = configField.getBoolean(null);
                return () -> result;
            }
            catch (Exception ex) {
                System.out.print(ex.toString());
                return () -> false;
            }
        }
    }

    public static class RecipeEnchantedBooksFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return new RecipeIMCEnchantedBooks();
        }
    }

    public static class RecipePresentFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return new RecipePresents();
        }
    }

    public static class RecipeRepairEnchantedFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return new RecipeRepairEnchantedItems();
        }
    }
}

