/*
 * Decompiled with CFR 0.152.
 */
package imc.common;

import imc.common.EntityPigman;
import imc.common.EntityWildPig;
import imc.common.IMC;
import imc.common.IMCReflection;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityLivingHandler {
    @SubscribeEvent
    public void onEntityLivingDeath(LivingDeathEvent event) {
        int min;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (IMC.retrieve_arrows_on_mobs && entityLiving.getEntityData().func_74764_b("arrows_dropped")) {
            entityLiving.func_145779_a(Items.field_151032_g, entityLiving.getEntityData().func_74762_e("arrows_dropped"));
        }
        if (IMC.bats_drop_leather && entityLiving instanceof EntityBat) {
            entityLiving.func_145779_a(Items.field_151116_aA, 1);
        } else if (IMC.wolves_drop_leather && entityLiving instanceof EntityWolf) {
            entityLiving.func_145779_a(Items.field_151116_aA, 1 + entityLiving.func_70681_au().nextInt(2));
        } else if (IMC.horse_and_squid_meat && entityLiving instanceof EntityHorse) {
            if (!entityLiving.func_70631_g_() && entityLiving.func_70681_au().nextInt(100) < IMC.horse_meat_drop_chance) {
                int n;
                int max = IMC.horse_meat_drop_max;
                min = IMC.horse_meat_drop_min;
                if (max < min) {
                    max = min = (min + max) / 2;
                }
                if ((n = min + entityLiving.func_70681_au().nextInt(max - min + 1)) > 0) {
                    entityLiving.func_145779_a(IMC.item_raw_horse, n);
                }
            }
        } else if (IMC.horse_and_squid_meat && entityLiving instanceof EntitySquid) {
            if (entityLiving.func_70681_au().nextInt(100) < IMC.squid_meat_drop_chance) {
                int n;
                int max = IMC.squid_meat_drop_max;
                min = IMC.squid_meat_drop_min;
                if (max < min) {
                    max = min = (min + max) / 2;
                }
                if ((n = min + entityLiving.func_70681_au().nextInt(max - min + 1)) > 0) {
                    entityLiving.func_145779_a(IMC.item_raw_squid, n);
                }
            }
        } else if (IMC.witches_drop_potions && entityLiving instanceof EntityWitch) {
            for (int i = entityLiving.func_70681_au().nextInt(3); i > 0; --i) {
                PotionType type = PotionTypes.field_185241_m;
                switch (entityLiving.func_70681_au().nextInt(9)) {
                    default: {
                        break;
                    }
                    case 1: {
                        type = PotionTypes.field_185250_v;
                        break;
                    }
                    case 2: {
                        type = PotionTypes.field_185236_h;
                        break;
                    }
                    case 3: {
                        type = PotionTypes.field_185238_j;
                        break;
                    }
                    case 4: {
                        type = PotionTypes.field_185234_f;
                        break;
                    }
                    case 5: {
                        type = PotionTypes.field_185220_C;
                        break;
                    }
                    case 6: {
                        type = PotionTypes.field_185223_F;
                        break;
                    }
                    case 7: {
                        type = PotionTypes.field_185243_o;
                        break;
                    }
                    case 8: {
                        type = PotionTypes.field_185248_t;
                    }
                }
                entityLiving.func_70099_a(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)type), 0.0f);
            }
        } else if (IMC.pigs_can_drop_leather && entityLiving instanceof EntityPig && entityLiving.func_70681_au().nextInt(100) < IMC.pig_drop_leather_chance && (entityLiving.getClass() != EntityWildPig.class || entityLiving.func_70681_au().nextInt(3) != 0)) {
            entityLiving.func_145779_a(Items.field_151116_aA, 1);
        }
        if (IMC.mobs_drop_skulls && entityLiving instanceof EntitySkeleton && ((EntitySkeleton)entityLiving).func_82202_m() != 1 && entityLiving.func_70681_au().nextInt(100) < IMC.mob_drop_skull_chance) {
            entityLiving.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
        } else if (IMC.mobs_drop_skulls && entityLiving instanceof EntityZombie && !(entityLiving instanceof EntityPigZombie) && entityLiving.func_70681_au().nextInt(100) < IMC.mob_drop_skull_chance) {
            entityLiving.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 2), 0.0f);
        } else if (IMC.mobs_drop_skulls && entityLiving instanceof EntityCreeper && entityLiving.func_70681_au().nextInt(100) < IMC.mob_drop_skull_chance) {
            entityLiving.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
        } else if (IMC.players_drop_heads && entityLiving instanceof EntityPlayer && entityLiving.func_70681_au().nextInt(100) < IMC.player_drop_head_chance) {
            ItemStack head = new ItemStack(Items.field_151144_bL, 1, 3);
            head.func_77982_d(new NBTTagCompound());
            head.func_77978_p().func_74778_a("SkullOwner", ((EntityPlayer)entityLiving).func_70005_c_());
            entityLiving.func_70099_a(head, 0.0f);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        int i;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase entityLiving = event.getEntityLiving();
        List drops = event.getDrops();
        if (IMC.dropped_items_less_damaged && entityLiving instanceof EntityLiving && !(entityLiving instanceof EntityPlayer) && !((EntityLiving)entityLiving).func_104002_bU()) {
            for (i = 0; i < drops.size(); ++i) {
                ItemStack item = ((EntityItem)drops.get(i)).func_92059_d();
                if (!(item.func_77973_b() instanceof ItemTool) && !(item.func_77973_b() instanceof ItemSword) && !(item.func_77973_b() instanceof ItemArmor) && !(item.func_77973_b() instanceof ItemBow) || item.func_77952_i() <= 0) continue;
                int n = item.func_77958_k() / 2;
                if (n < 1) {
                    n = 1;
                }
                item.func_77964_b(entityLiving.func_70681_au().nextInt(n));
            }
        }
        if (IMC.endermen_always_drop && entityLiving instanceof EntityEnderman) {
            if (drops.isEmpty()) {
                drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(Items.field_151079_bi)));
            }
        } else if (IMC.creepers_can_drop_tnt && entityLiving instanceof EntityCreeper) {
            if (entityLiving.func_70681_au().nextInt(100) < IMC.creeper_drop_tnt_chance) {
                drops.clear();
                drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(Blocks.field_150335_W)));
            }
        } else if (IMC.spiders_can_drop_cobweb && entityLiving instanceof EntitySpider) {
            if (entityLiving.func_70681_au().nextInt(100) < IMC.spider_drop_cobweb_chance) {
                drops.clear();
                drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(Blocks.field_150321_G)));
            }
        } else if (entityLiving instanceof EntitySkeleton && ((EntitySkeleton)entityLiving).func_82202_m() == 1) {
            if (IMC.obsidian_sword) {
                for (i = 0; i < drops.size(); ++i) {
                    if (((EntityItem)drops.get(i)).func_92059_d().func_77973_b() != IMC.item_obsidian_sword) continue;
                    drops.remove(i);
                }
                if (entityLiving.func_70681_au().nextInt(100) < IMC.obsidian_sword_drop_chance_on_wither_skeleton) {
                    drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(IMC.item_obsidian_sword, 1, entityLiving.func_70681_au().nextInt(IMC.item_obsidian_sword.func_77612_l() / 2))));
                }
            }
            if (IMC.wither_skeletons_drop_black_bones && entityLiving.func_70681_au().nextInt(100) < IMC.wither_skeleton_drop_black_bone_chance) {
                drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(IMC.item_black_bone)));
            }
        } else if (IMC.zombie_pigmen_drop_cooked_porkchops && entityLiving instanceof EntityPigZombie) {
            for (i = 0; i < drops.size(); ++i) {
                if (((EntityItem)drops.get(i)).func_92059_d().func_77973_b() != Items.field_151078_bh) continue;
                ((EntityItem)drops.get(i)).func_92058_a(new ItemStack(Items.field_151157_am, ((EntityItem)drops.get((int)i)).func_92059_d().field_77994_a));
            }
        }
        if (IMC.fireballs_cook_drops && event.getSource().func_76364_f() != null && event.getSource().func_76364_f() instanceof EntitySmallFireball) {
            for (i = 0; i < drops.size(); ++i) {
                ItemStack stack;
                ItemStack drop = ((EntityItem)drops.get(i)).func_92059_d();
                if (drop == null || drop.func_77975_n() != EnumAction.EAT || (stack = FurnaceRecipes.func_77602_a().func_151395_a(drop)) == null) continue;
                ((EntityItem)drops.get(i)).func_92058_a(new ItemStack(stack.func_77973_b(), drop.field_77994_a * stack.field_77994_a, stack.func_77952_i()));
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving == null) {
            return;
        }
        if (IMC.obsidian_sword && entityLiving instanceof EntitySkeleton && ((EntitySkeleton)entityLiving).func_82202_m() == 1 && entityLiving.func_184614_ca() != null && entityLiving.func_184614_ca().func_77973_b() == Items.field_151052_q) {
            entityLiving.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(IMC.item_obsidian_sword));
        } else if (IMC.baby_zombies_burn && !entityLiving.field_70170_p.field_72995_K && entityLiving instanceof EntityZombie && entityLiving.func_70631_g_() && entityLiving.field_70170_p.func_72935_r()) {
            float f = entityLiving.func_70013_c(1.0f);
            if (f > 0.5f && entityLiving.func_70681_au().nextFloat() * 30.0f < (f - 0.4f) * 2.0f && entityLiving.field_70170_p.func_175678_i(new BlockPos((double)((int)entityLiving.field_70165_t), (double)Math.round(entityLiving.field_70163_u), (double)((int)entityLiving.field_70161_v)))) {
                boolean flag = true;
                ItemStack itemstack = entityLiving.func_184582_a(EntityEquipmentSlot.HEAD);
                if (itemstack != null) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_77964_b(itemstack.func_77952_i() + entityLiving.func_70681_au().nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            entityLiving.func_70669_a(itemstack);
                            entityLiving.func_184201_a(EntityEquipmentSlot.HEAD, null);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    entityLiving.func_70015_d(8);
                }
            }
        } else if (IMC.chickens_leave_feathers && entityLiving instanceof EntityChicken && !entityLiving.func_70631_g_() && !entityLiving.field_70170_p.field_72995_K) {
            if (!entityLiving.getEntityData().func_74764_b("time_until_next_feather")) {
                int n = 2 * IMC.chicken_feather_rarity / 3;
                if (n < 1) {
                    n = 1;
                }
                entityLiving.getEntityData().func_74768_a("time_until_next_feather", n + entityLiving.func_70681_au().nextInt(n));
            } else {
                int time = entityLiving.getEntityData().func_74762_e("time_until_next_feather") - 1;
                if (time <= 0) {
                    int n = 2 * IMC.chicken_feather_rarity / 3;
                    if (n < 1) {
                        n = 1;
                    }
                    entityLiving.func_145779_a(Items.field_151008_G, 1);
                    entityLiving.getEntityData().func_74768_a("time_until_next_feather", n + entityLiving.func_70681_au().nextInt(n));
                } else {
                    entityLiving.getEntityData().func_74768_a("time_until_next_feather", time);
                }
            }
        } else if (IMC.cure_zombie_pigmen && entityLiving.getClass() == EntityPigZombie.class && !entityLiving.field_70170_p.field_72995_K) {
            EntityPigZombie pigZombie = (EntityPigZombie)entityLiving;
            if (pigZombie.func_82230_o() && IMCReflection.getConversionTime((EntityZombie)pigZombie) <= 1000) {
                EntityPigman pigman = new EntityPigman(pigZombie.field_70170_p);
                pigman.func_82149_j((Entity)pigZombie);
                pigman.func_180482_a(pigZombie.field_70170_p.func_175649_E(new BlockPos((Entity)pigman)), null);
                pigman.func_184201_a(EntityEquipmentSlot.HEAD, pigZombie.func_184582_a(EntityEquipmentSlot.HEAD));
                pigman.func_184201_a(EntityEquipmentSlot.CHEST, pigZombie.func_184582_a(EntityEquipmentSlot.CHEST));
                pigman.func_184201_a(EntityEquipmentSlot.LEGS, pigZombie.func_184582_a(EntityEquipmentSlot.LEGS));
                pigman.func_184201_a(EntityEquipmentSlot.FEET, pigZombie.func_184582_a(EntityEquipmentSlot.FEET));
                pigman.func_184201_a(EntityEquipmentSlot.MAINHAND, pigZombie.func_184582_a(EntityEquipmentSlot.MAINHAND));
                pigman.func_184201_a(EntityEquipmentSlot.OFFHAND, pigZombie.func_184582_a(EntityEquipmentSlot.OFFHAND));
                if (pigZombie.func_145818_k_()) {
                    pigman.func_96094_a(pigZombie.func_95999_t());
                    pigman.func_174805_g(pigZombie.func_174833_aM());
                }
                pigZombie.field_70170_p.func_72900_e((Entity)pigZombie);
                pigman.field_70170_p.func_72838_d((Entity)pigman);
                pigman.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
                pigman.field_70170_p.func_184133_a(null, new BlockPos((Entity)pigman), SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 2.0f, (pigman.func_70681_au().nextFloat() - pigman.func_70681_au().nextFloat()) * 0.2f + 1.0f);
            }
        } else if (IMC.water_walking_enchantment_on_boots && entityLiving instanceof EntityPlayer && !entityLiving.field_70122_E && ((EntityPlayer)entityLiving).func_184582_a(EntityEquipmentSlot.FEET) != null && EnchantmentHelper.func_77506_a((Enchantment)IMC.enchantment_water_walking, (ItemStack)((EntityPlayer)entityLiving).func_184582_a(EntityEquipmentSlot.FEET)) > 0) {
            AxisAlignedBB box = entityLiving.func_174813_aQ();
            if (entityLiving.field_70170_p.func_72830_b(box.func_72314_b(0.0, -0.1, 0.0), Material.field_151586_h)) {
                if (entityLiving.field_70181_x < 0.0) {
                    entityLiving.field_70181_x = 0.0;
                }
                entityLiving.field_70181_x += 0.02;
                entityLiving.field_70143_R = 0.0f;
            } else if (entityLiving.field_70170_p.func_72830_b(box.func_72314_b(0.0, 0.02, 0.0), Material.field_151586_h)) {
                entityLiving.field_70122_E = true;
                entityLiving.field_70181_x = 0.0;
                entityLiving.field_70143_R = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (IMC.retrieve_arrows_on_mobs && event.getSource().func_76364_f() instanceof EntityArrow && event.getSource().func_76346_g() instanceof EntityPlayer && ((EntityArrow)event.getSource().func_76364_f()).field_70251_a == EntityArrow.PickupStatus.ALLOWED && event.getEntityLiving().func_70681_au().nextInt(100) < IMC.retrieve_arrow_chance) {
            if (event.getEntityLiving().getEntityData().func_74764_b("arrows_dropped")) {
                event.getEntityLiving().getEntityData().func_74768_a("arrows_dropped", event.getEntityLiving().getEntityData().func_74762_e("arrows_dropped") + 1);
            } else {
                event.getEntityLiving().getEntityData().func_74768_a("arrows_dropped", 1);
            }
        } else if (IMC.health_draining_enchantment_on_swords && event.getSource().func_76364_f() instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.getSource().func_76364_f()).func_184614_ca()) != null && EnchantmentHelper.func_77506_a((Enchantment)IMC.enchantment_health_draining, (ItemStack)stack) > 0) {
            int amount = EnchantmentHelper.func_77506_a((Enchantment)IMC.enchantment_health_draining, (ItemStack)stack);
            event.getEntityLiving().func_70097_a(DamageSource.field_76376_m, (float)amount);
            player.func_70691_i((float)amount);
        }
        if (IMC.fire_and_explosions_can_ignite_creepers && event.getEntityLiving() instanceof EntityCreeper && (event.getSource().func_76347_k() || event.getSource().func_94541_c()) && event.getEntityLiving().func_70681_au().nextInt(100) < IMC.fire_and_explosions_ignite_creeper_chance) {
            ((EntityCreeper)event.getEntityLiving()).func_146079_cb();
        }
    }
}

