/*
 * Decompiled with CFR 0.152.
 */
package imc.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityPigman
extends EntityCreature
implements IMerchant {
    private static final List<PigmanTrade> tradeList;
    private int hostileCountdown;
    private int timeUntilReset;
    private boolean needsInitialization;
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private String playerToAttack = "";

    public EntityPigman(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.9, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public void func_70636_d() {
        if (this.hostileCountdown > 0) {
            if (--this.hostileCountdown == 0) {
                this.func_70624_b(null);
            } else if (this.func_70638_az() == null && !this.playerToAttack.isEmpty()) {
                super.func_70624_b((EntityLivingBase)this.field_70170_p.func_72924_a(this.playerToAttack));
            }
        }
        super.func_70636_d();
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
        return super.func_180482_a(difficulty, livingdata);
    }

    public void func_70624_b(EntityLivingBase entity) {
        this.playerToAttack = entity != null && entity instanceof EntityPlayer ? entity.func_70005_c_() : "";
        super.func_70624_b(entity);
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source.func_76346_g() == null || !(source.func_76346_g() instanceof EntityLivingBase) || source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d)) {
            List list = this.field_70170_p.func_72872_a(EntityPigman.class, this.func_174813_aQ().func_72314_b(25.0, 25.0, 25.0));
            for (int i = 0; i < list.size(); ++i) {
                ((EntityPigman)((Object)list.get(i))).func_70624_b((EntityLivingBase)source.func_76346_g());
                ((EntityPigman)((Object)list.get((int)i))).hostileCountdown = 350 + this.field_70146_Z.nextInt(80);
            }
        }
        return super.func_70097_a(source, par2);
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.func_184614_ca() != null && this.func_184614_ca().func_77973_b() == Items.field_151010_B) {
            attackDamage -= Item.ToolMaterial.GOLD.func_78000_c();
        }
        if ((flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) && entity instanceof EntityLivingBase) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return flag;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 2 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public int func_70627_aG() {
        return 160;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187703_dN;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    protected void func_70628_a(boolean b, int fortuneLevel) {
        if (fortuneLevel >= 0) {
            for (int i = 1 + this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + fortuneLevel); i > 0; --i) {
                this.func_145779_a(this.func_70027_ad() ? Items.field_151157_am : Items.field_151147_al, 1);
            }
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("hostileCountdown", this.hostileCountdown);
        tag.func_74778_a("playerToAttack", this.playerToAttack);
        if (this.buyingList != null) {
            tag.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.hostileCountdown = tag.func_74762_e("hostileCountdown");
        this.playerToAttack = tag.func_74779_i("playerToAttack");
        if (tag.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = tag.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if ((itemstack == null || itemstack.func_77973_b() != Items.field_151063_bx) && this.func_70089_S() && this.buyingPlayer == null && this.func_70638_az() == null && !player.func_70093_af()) {
            if (!(this.field_70170_p.field_72995_K || this.buyingList != null && this.buyingList.size() <= 0)) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            }
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    protected void func_70619_bc() {
        if (this.buyingPlayer == null && this.timeUntilReset > 0 && --this.timeUntilReset == 0 && this.needsInitialization) {
            if (this.buyingList.size() < 4) {
                this.populateBuyingList();
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
            this.needsInitialization = false;
        }
        super.func_70619_bc();
    }

    public void func_70932_a_(EntityPlayer player) {
        this.buyingPlayer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
        this.buyingList = recipeList;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        if (recipe.func_77394_a().func_77973_b() instanceof ItemArmor) {
            this.func_184201_a(((ItemArmor)recipe.func_77394_a().func_77973_b()).field_77881_a, new ItemStack(recipe.func_77394_a().func_77973_b()));
        }
        recipe.func_77399_f();
        this.func_184185_a(this.func_184639_G(), this.func_70599_aP() * 1.5f, this.func_70647_i());
        if (recipe.func_82784_g()) {
            this.buyingList.remove((Object)recipe);
        }
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.buyingList.size() == 0 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitialization = true;
            i += 5;
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void func_110297_a_(ItemStack stack) {
    }

    private void populateBuyingList() {
        int i;
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            ArrayList<EntityEquipmentSlot> missingEquipments = new ArrayList<EntityEquipmentSlot>();
            if (this.func_184582_a(EntityEquipmentSlot.HEAD) == null) {
                missingEquipments.add(EntityEquipmentSlot.HEAD);
            }
            if (this.func_184582_a(EntityEquipmentSlot.CHEST) == null) {
                missingEquipments.add(EntityEquipmentSlot.CHEST);
            }
            if (this.func_184582_a(EntityEquipmentSlot.LEGS) == null) {
                missingEquipments.add(EntityEquipmentSlot.LEGS);
            }
            if (this.func_184582_a(EntityEquipmentSlot.FEET) == null) {
                missingEquipments.add(EntityEquipmentSlot.FEET);
            }
            for (i = 0; !missingEquipments.isEmpty() && i < this.buyingList.size(); ++i) {
                if (!(((MerchantRecipe)this.buyingList.get(i)).func_77394_a().func_77973_b() instanceof ItemArmor)) continue;
                missingEquipments.remove(((ItemArmor)((MerchantRecipe)this.buyingList.get((int)i)).func_77394_a().func_77973_b()).field_77881_a);
            }
            if (!missingEquipments.isEmpty()) {
                EntityEquipmentSlot slot = (EntityEquipmentSlot)missingEquipments.get(this.field_70146_Z.nextInt(missingEquipments.size()));
                this.buyingList.add((Object)new MerchantRecipe(new ItemStack(EntityLiving.func_184636_a((EntityEquipmentSlot)slot, (int)(1 + this.field_70146_Z.nextInt(3)))), null, new ItemStack(Items.field_151166_bC, (slot == EntityEquipmentSlot.CHEST || slot == EntityEquipmentSlot.LEGS ? 3 : 2) + this.field_70146_Z.nextInt(2)), 0, 1));
                return;
            }
        }
        ArrayList<Integer> missingTrades = new ArrayList<Integer>();
        block1: for (i = 0; i < tradeList.size(); ++i) {
            for (int j = 0; j < this.buyingList.size(); ++j) {
                if (!((MerchantRecipe)this.buyingList.get(j)).func_82784_g() && tradeList.get(i).correspondsTo((MerchantRecipe)this.buyingList.get(j))) continue block1;
            }
            missingTrades.add(i);
        }
        if (missingTrades.size() > 0) {
            tradeList.get((Integer)missingTrades.get(this.field_70146_Z.nextInt(missingTrades.size()))).func_179401_a(this.buyingList, this.field_70146_Z);
        }
    }

    static {
        Enchantment[] enchantmentList;
        tradeList = new ArrayList<PigmanTrade>();
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151025_P), 5, 8, new ItemStack(Items.field_151166_bC), 1, 1));
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151034_e), 7, 10, new ItemStack(Items.field_151166_bC), 1, 1));
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151127_ba), 12, 18, new ItemStack(Items.field_151166_bC), 1, 1));
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151166_bC), 7, 9, new ItemStack(Items.field_151075_bm), 2, 3));
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151166_bC), 3, 4, new ItemStack(Items.field_151073_bk), 1, 1));
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151166_bC), 1, 1, new ItemStack(Items.field_151016_H), 4, 5));
        for (Enchantment ench : enchantmentList = new Enchantment[]{Enchantments.field_185304_p, Enchantments.field_185302_k, Enchantments.field_185307_s}) {
            ItemStack enchantedSword = new ItemStack(Items.field_151010_B);
            enchantedSword.func_77966_a(ench, 2);
            tradeList.add(new PigmanTrade(new ItemStack(Items.field_151010_B), 1, 1, new ItemStack(Items.field_151166_bC), 5, 7, enchantedSword, 1, 1));
        }
    }

    private static class PigmanTrade
    implements EntityVillager.ITradeList {
        private ItemStack buy1;
        private ItemStack buy2;
        private ItemStack sell;
        private int qBuy1Min;
        private int qBuy1Max;
        private int qBuy2Min;
        private int qBuy2Max;
        private int qSellMin;
        private int qSellMax;
        private int uses;

        public PigmanTrade(ItemStack b, int qmin, int qmax, ItemStack s, int smin, int smax) {
            this(b, qmin, qmax, null, 0, 0, s, smin, smax);
        }

        public PigmanTrade(ItemStack b1, int q1min, int q1max, ItemStack b2, int q2min, int q2max, ItemStack s, int smin, int smax) {
            this.buy1 = b1;
            this.qBuy1Min = q1min;
            this.qBuy1Max = q1max;
            this.buy2 = b2;
            this.qBuy2Min = q2min;
            this.qBuy2Max = q2max;
            this.sell = s;
            this.qSellMin = smin;
            this.qSellMax = smax;
            this.uses = this.buy2 == null ? 7 : 2;
        }

        public boolean correspondsTo(MerchantRecipe recipe) {
            if (recipe.func_77394_a().func_77973_b() != this.buy1.func_77973_b() || recipe.func_77394_a().func_77952_i() != this.buy1.func_77952_i()) {
                return false;
            }
            if (this.buy2 == null != (recipe.func_77396_b() == null)) {
                return false;
            }
            if (this.buy2 != null && (recipe.func_77396_b().func_77973_b() != this.buy2.func_77973_b() || recipe.func_77396_b().func_77952_i() != this.buy2.func_77952_i())) {
                return false;
            }
            return recipe.func_77397_d().func_77973_b() == this.sell.func_77973_b() && recipe.func_77397_d().func_77952_i() == this.sell.func_77952_i();
        }

        public void func_179401_a(MerchantRecipeList recipeList, Random rand) {
            ItemStack b1 = this.buy1.func_77946_l();
            ItemStack b2 = null;
            ItemStack s = this.sell.func_77946_l();
            b1.field_77994_a = this.qBuy1Min + rand.nextInt(this.qBuy1Max - this.qBuy1Min + 1);
            if (this.buy2 != null) {
                b2 = this.buy2.func_77946_l();
                b2.field_77994_a = this.qBuy2Min + rand.nextInt(this.qBuy2Max - this.qBuy2Min + 1);
            }
            s.field_77994_a = this.qSellMin + rand.nextInt(this.qSellMax - this.qSellMin + 1);
            recipeList.add((Object)new MerchantRecipe(b1, b2, s, 0, this.uses));
        }
    }
}

