/*
 * Decompiled with CFR 0.152.
 */
package imc.asm;

import imc.common.IMC;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class IMCClassTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String newName, byte[] byteCode) {
        boolean isObfuscated;
        boolean bl = isObfuscated = !name.equals(newName);
        if (newName.equals("net.minecraft.item.crafting.CraftingManager")) {
            IMC.Log.log(Level.INFO, "Patching CraftingManager, method: " + name);
            return this.patchMatchingRecipe(name, byteCode, isObfuscated);
        }
        if (newName.equals("net.minecraft.tileentity.MobSpawnerBaseLogic")) {
            IMC.Log.log(Level.INFO, "Patching Minecraft MobSpawnerBaseLogic");
            ClassNode classNode = this.readClassFromBytes(byteCode);
            MethodNode methodNode = this.findMethodNodeOfClass(classNode, isObfuscated ? "g" : "updateSpawner", "()V");
            if (methodNode != null) {
                this.captureIsSpawningFromSpawner(methodNode);
                return this.writeClassToBytes(classNode);
            }
            IMC.Log.log(Level.ERROR, "Could not find updateSpawner method in MobSpawnerBaseLogic");
            return byteCode;
        }
        if (newName.equals("net.minecraft.entity.monster.EntityMob")) {
            IMC.Log.log(Level.INFO, "Patching Minecraft EntityMob");
            ClassNode classNode = this.readClassFromBytes(byteCode);
            MethodNode methodNode1 = this.findMethodNodeOfClass(classNode, isObfuscated ? "by" : "getCanSpawnHere", "()Z");
            MethodNode methodNode2 = this.findMethodNodeOfClass(classNode, isObfuscated ? "a" : "getBlockPathWeight", "(III)F");
            if (methodNode1 != null && methodNode2 != null) {
                this.makeEntityMobIgnoreLightLevel(methodNode1);
                this.makeEntityMobIgnoreWorldLightLevel(methodNode2);
                return this.writeClassToBytes(classNode);
            }
            IMC.Log.log(Level.ERROR, "Could not find getCanSpawnHere or getBlockPathWeight methods in EntityMob");
            return byteCode;
        }
        if (name.equals("lycanite.lycanitesmobs.api.entity.EntityCreatureBase")) {
            IMC.Log.log(Level.INFO, "Patching LycanitesMobs EntityCreatureBase");
            ClassNode classNode = this.readClassFromBytes(byteCode);
            MethodNode methodNode = this.findMethodNodeOfClass(classNode, "fixedSpawnCheck", "(Lnet/minecraft/world/World;III)Z");
            if (methodNode != null) {
                this.makeLycanitesMobsIgnoreLightLevel(methodNode);
                return this.writeClassToBytes(classNode);
            }
            IMC.Log.log(Level.ERROR, "Could not find fixedSpawnCheck in EntityCreatureBase");
            return byteCode;
        }
        if (name.equals("net.minecraft.entity.Entity")) {
            IMC.Log.log(Level.INFO, "Patching Enitity Sneaking");
            ClassNode classNode = this.readClassFromBytes(byteCode);
            MethodNode methodNode = this.findMethodNodeOfClass(classNode, isObfuscated ? "d" : "moveEntity", "(DDD)V");
            if (methodNode != null) {
                this.ignoreSneaking(methodNode);
                return this.writeClassToBytes(classNode);
            }
            IMC.Log.log(Level.ERROR, "Could not find moveEntity in Entity");
            return byteCode;
        }
        return byteCode;
    }

    public byte[] patchMatchingRecipe(String name, byte[] bytes, boolean obfuscated) {
        String targetMethodName = "";
        String targetSignature = "";
        if (obfuscated) {
            targetMethodName = "a";
            targetSignature = "(Laae;Lahb;)Ladd;";
        } else {
            targetMethodName = "findMatchingRecipe";
            targetSignature = "(Lnet/minecraft/inventory/InventoryCrafting;Lnet/minecraft/world/World;)Lnet/minecraft/item/ItemStack;";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(targetMethodName) || !m.desc.equals(targetSignature)) continue;
            IMC.Log.log(Level.INFO, "********* Inside target method!");
            AbstractInsnNode currentNode2 = null;
            for (AbstractInsnNode currentNode2 : m.instructions) {
                if (currentNode2.getOpcode() != 162) continue;
                JumpInsnNode j = (JumpInsnNode)currentNode2;
                m.instructions.insertBefore(currentNode2, (AbstractInsnNode)new JumpInsnNode(167, j.label));
                break;
            }
            IMC.Log.log(Level.INFO, "Patching Complete!");
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public void captureIsSpawningFromSpawner(MethodNode method) {
        AbstractInsnNode firstNode = this.findFirstInstruction(method);
        AbstractInsnNode lastNode = this.findLastInstructionOfType(method, 177);
        if (firstNode == null || lastNode == null || lastNode.getOpcode() != 177) {
            throw new RuntimeException("Could not find target nodes for MobSpawnerBaseLogic patch");
        }
        InsnList firstInject = new InsnList();
        InsnList lastInject = new InsnList();
        firstInject.add((AbstractInsnNode)new InsnNode(4));
        firstInject.add((AbstractInsnNode)new FieldInsnNode(179, "imc/asm/Hooks", "isSpawningFromSpawner", "Z"));
        lastInject.add((AbstractInsnNode)new InsnNode(3));
        lastInject.add((AbstractInsnNode)new FieldInsnNode(179, "imc/asm/Hooks", "isSpawningFromSpawner", "Z"));
        method.instructions.insertBefore(firstNode, firstInject);
        method.instructions.insertBefore(lastNode, lastInject);
        IMC.Log.log(Level.INFO, "Patched: " + method.name);
    }

    public void makeEntityMobIgnoreLightLevel(MethodNode method) {
        AbstractInsnNode firstTargetNode = this.findNthInstructionOfType(method, 25, 2);
        AbstractInsnNode secondTargetNode = this.findNthInstructionOfType(method, 25, 3);
        if (firstTargetNode == null || secondTargetNode == null) {
            throw new RuntimeException("Could not find target nodes for EntityMob." + method.name + " patch");
        }
        InsnList firstInject = new InsnList();
        InsnList secondInject = new InsnList();
        firstInject.add((AbstractInsnNode)new FieldInsnNode(184, "imc/asm/Hooks", "canSpawn", "()Z"));
        LabelNode label = new LabelNode();
        firstInject.add((AbstractInsnNode)new JumpInsnNode(154, label));
        secondInject.add((AbstractInsnNode)label);
        secondInject.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method.instructions.insertBefore(firstTargetNode, firstInject);
        method.instructions.insertBefore(secondTargetNode, secondInject);
        IMC.Log.log(Level.INFO, "Patched: " + method.name);
    }

    public void makeEntityMobIgnoreWorldLightLevel(MethodNode method) {
        AbstractInsnNode targetNode = this.findFirstInstruction(method);
        if (targetNode == null) {
            throw new RuntimeException("Could not find target node for EntityMob." + method.name + " patch");
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new FieldInsnNode(184, "imc/asm/Hooks", "canSpawn", "()Z"));
        LabelNode label = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, label));
        toInject.add((AbstractInsnNode)new InsnNode(11));
        toInject.add((AbstractInsnNode)new InsnNode(174));
        toInject.add((AbstractInsnNode)label);
        method.instructions.insertBefore(targetNode, toInject);
        IMC.Log.log(Level.INFO, "Patched: " + method.name);
    }

    public void makeLycanitesMobsIgnoreLightLevel(MethodNode method) {
        AbstractInsnNode firstTargetNode = this.findFirstInstructionOfType(method, 164);
        AbstractInsnNode secondTargetNode = this.findFirstInstructionOfType(method, 162);
        AbstractInsnNode thirdTargetNode = this.findFirstInstructionOfType(method, 172);
        AbstractInsnNode fourthTargetNode = this.findNthInstructionOfType(method, 172, 2);
        if (firstTargetNode == null || secondTargetNode == null || thirdTargetNode == null || fourthTargetNode == null) {
            throw new RuntimeException("Could not find target node for EntityCreatureBase" + method.name + "patch");
        }
        InsnList firstInject = new InsnList();
        InsnList secondInject = new InsnList();
        InsnList firstLabelInject = new InsnList();
        InsnList secondLabelInject = new InsnList();
        firstInject.add((AbstractInsnNode)new FieldInsnNode(184, "imc/asm/Hooks", "canSpawn", "()Z"));
        LabelNode label1 = new LabelNode();
        firstInject.add((AbstractInsnNode)new JumpInsnNode(154, label1));
        secondInject.add((AbstractInsnNode)new FieldInsnNode(184, "imc/asm/Hooks", "canSpawn", "()Z"));
        LabelNode label2 = new LabelNode();
        secondInject.add((AbstractInsnNode)new JumpInsnNode(154, label2));
        firstLabelInject.add((AbstractInsnNode)label1);
        secondLabelInject.add((AbstractInsnNode)label2);
        method.instructions.insert(firstTargetNode, firstInject);
        method.instructions.insert(secondTargetNode, secondInject);
        method.instructions.insert(thirdTargetNode, firstLabelInject);
        method.instructions.insert(fourthTargetNode, secondLabelInject);
        IMC.Log.log(Level.INFO, "Patched: " + method.name);
    }

    public void ignoreSneaking(MethodNode method) {
        JumpInsnNode targetNode = (JumpInsnNode)this.findNthInstructionOfType(method, 153, 6);
        if (targetNode == null) {
            throw new RuntimeException("Could not find target node for EntityMob." + method.name + " patch");
        }
        InsnList toInject = new InsnList();
        LabelNode label = targetNode.label;
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, label));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, "imc/common/IMC", "can_sneak_off_ledges", "Z"));
        method.instructions.insertBefore((AbstractInsnNode)targetNode, toInject);
        IMC.Log.log(Level.INFO, "Patched: " + method.name);
    }

    private ClassNode readClassFromBytes(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private byte[] writeClassToBytes(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private AbstractInsnNode findFirstInstruction(MethodNode method) {
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getType() == 8 || instruction.getType() == 15) continue;
            return instruction;
        }
        return null;
    }

    private AbstractInsnNode findFirstInstructionOfType(MethodNode method, int bytecode) {
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != bytecode) continue;
            return instruction;
        }
        return null;
    }

    private AbstractInsnNode findLastInstructionOfType(MethodNode method, int bytecode) {
        for (AbstractInsnNode instruction = method.instructions.getLast(); instruction != null; instruction = instruction.getPrevious()) {
            if (instruction.getOpcode() != bytecode) continue;
            return instruction;
        }
        return null;
    }

    private AbstractInsnNode findNthInstructionOfType(MethodNode method, int bytecode, int number) {
        int i = 0;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != bytecode || ++i != number) continue;
            return instruction;
        }
        return null;
    }

    private MethodNode findMethodNodeOfClass(ClassNode classNode, String methodName, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }
}

