/*
 * Decompiled with CFR 0.152.
 */
package imc.client;

import cpw.mods.fml.common.FMLLog;
import imc.common.IMC;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class IMCMobSpawnerItemRenderer
implements IItemRenderer {
    HashMap<String, EntityLiving> cachedEntity = new HashMap();

    public IMCMobSpawnerItemRenderer(TileEntitySpecialRenderer render) {
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        World world = null;
        String mobId = "pig";
        if (RenderManager.field_78727_a.field_78724_e == null) {
            return;
        }
        world = Minecraft.func_71410_x().field_71439_g.func_130014_f_();
        if (world == null) {
            FMLLog.getLogger().log(Level.ERROR, "Missing World for " + type);
            return;
        }
        EntityLiving entity = null;
        NBTTagCompound tag = item.func_77978_p();
        if (tag != null) {
            mobId = tag.func_74779_i("EntityId");
            if (mobId == null || mobId.length() == 0) {
                return;
            }
            entity = this.getCachedEntity(mobId, world);
        }
        if (entity != null) {
            float scale = 0.4375f;
            if (entity instanceof EntityGhast || entity instanceof EntityGiantZombie || entity instanceof EntityDragon) {
                scale *= 0.5f;
            } else if (entity instanceof EntityBat || entity instanceof EntitySilverfish) {
                scale *= 3.0f;
            }
            Block block = IMC.block_mob_spawner;
            double rotScale = 20.0;
            float rot = world.func_82737_E() % (long)((int)(360.0 / rotScale));
            GL11.glPushMatrix();
            GL11.glRotatef((float)((float)((double)rot * rotScale)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 1.0f, 1.0f);
            GL11.glPopMatrix();
            GL11.glDisable((int)32826);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GL11.glDisable((int)3553);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
            RenderManager.field_78727_a.field_78724_e.func_110577_a(TextureMap.field_110575_b);
            RenderBlocks.getInstance().func_147800_a(block, 0, 1.0f);
        }
    }

    private EntityLiving getCachedEntity(String thisId, World world) {
        EntityLiving e = this.cachedEntity.get(thisId);
        if (e == null) {
            e = (EntityLiving)EntityList.func_75620_a((String)thisId, (World)world);
            this.cachedEntity.put(thisId, e);
        }
        return e;
    }
}

