/*
 * Decompiled with CFR 0.152.
 */
package imc.common;

import cpw.mods.fml.common.FMLLog;
import imc.common.IMC;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import org.apache.logging.log4j.Level;

public abstract class IMCReflection {
    private static Field conversionTime;
    private static Method startConversion;

    public static Field getField(Class<?> objectClass, String obf, String deobf) {
        Field f = null;
        try {
            f = objectClass.getDeclaredField(obf);
        }
        catch (Exception e) {
            IMC.Log.log(Level.INFO, "Unable to find obfuscated field named " + obf + " in class " + objectClass.getName());
            try {
                f = objectClass.getDeclaredField(deobf);
            }
            catch (Exception e2) {
                IMC.Log.log(Level.ERROR, "Unable to find deobfuscated field named " + deobf + " in class " + objectClass.getName());
            }
        }
        if (f != null) {
            f.setAccessible(true);
        }
        return f;
    }

    public static Method getMethod(Class<?> objectClass, String obf, String deobf, Class<?> returnClass) {
        Method m = null;
        try {
            m = objectClass.getDeclaredMethod(obf, returnClass);
        }
        catch (Exception e) {
            IMC.Log.log(Level.INFO, "Unable to find obfuscated method named " + obf + " in class " + objectClass.getName());
            try {
                m = objectClass.getDeclaredMethod(deobf, returnClass);
            }
            catch (Exception e2) {
                IMC.Log.log(Level.ERROR, "Unable to find deobfuscated method named " + deobf + " in class " + objectClass.getName());
            }
        }
        if (m != null) {
            m.setAccessible(true);
        }
        return m;
    }

    public static void init() {
        if (IMC.cure_zombie_pigmen) {
            conversionTime = IMCReflection.getField(EntityZombie.class, "field_82234_d", "conversionTime");
            startConversion = IMCReflection.getMethod(EntityZombie.class, "func_82228_a", "startConversion", Integer.TYPE);
            if (conversionTime == null || startConversion == null) {
                IMC.cure_zombie_pigmen = false;
            }
        }
        if (IMC.increased_gold_damage && !IMCReflection.increaseGoldDamage()) {
            IMC.increased_gold_damage = false;
        }
    }

    public static void enableDangerousFire() {
        try {
            Field bif = IMCReflection.getField(BlockFire.class, "blockInfo", "blockInfo");
            Class<?> c = Class.forName("net.minecraft.block.BlockFire$FireInfo");
            Field f1 = IMCReflection.getField(c, "encouragement", "encouragement");
            Field f2 = IMCReflection.getField(c, "flammibility", "flammibility");
            IdentityHashMap blockInfo = null;
            blockInfo = (IdentityHashMap)bif.get(Blocks.field_150480_ab);
            for (Map.Entry e : blockInfo.entrySet()) {
                f1.set(e.getValue(), (Integer)f1.get(e.getValue()) * 10);
                f2.set(e.getValue(), (Integer)f2.get(e.getValue()) * 3);
            }
            Blocks.field_150480_ab.rebuildFireInfo();
        }
        catch (Exception e1) {
            FMLLog.getLogger().log(Level.ERROR, "IMC: Problem setting dangerous fire stats - " + e1.getMessage());
        }
    }

    public static boolean increaseGoldDamage() {
        Field field = IMCReflection.getField(Item.ToolMaterial.class, "field_78011_i", "damageVsEntity");
        Field field2 = IMCReflection.getField(ItemSword.class, "field_150934_a", "field_150934_a");
        Field field3 = IMCReflection.getField(ItemTool.class, "field_77865_bY", "damageVsEntity");
        try {
            field.set(Item.ToolMaterial.GOLD, Float.valueOf(3.0f));
            field2.set(Items.field_151010_B, Float.valueOf(6.0f));
            field2.set(IMC.item_machete_gold, Float.valueOf(6.0f));
            field3.set(Items.field_151011_C, Float.valueOf(4.5f));
            field3.set(Items.field_151005_D, Float.valueOf(4.0f));
            field3.set(Items.field_151006_E, Float.valueOf(8.0f));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean reducedFlintDamage() {
        Field dmgField = IMCReflection.getField(ItemTool.class, "field_77865_bY", "damageVsEntity");
        try {
            dmgField.set(IMC.item_flint_spade, Float.valueOf(0.25f));
            dmgField.set(IMC.item_flint_pick, Float.valueOf(0.25f));
            dmgField.set(IMC.item_flint_hatchet, Float.valueOf(0.5f));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void startConversion(EntityZombie zombie, int time) {
        try {
            startConversion.invoke((Object)zombie, time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getConversionTime(EntityZombie zombie) {
        try {
            return conversionTime.getInt(zombie);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

