/*
 * Decompiled with CFR 0.152.
 */
package imc.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import imc.ai.EntityAIApproachAndAttack;
import imc.ai.EntityAIHellHoundBeg;
import imc.ai.EntityAIHellHoundNearestAttackablePlayer;
import imc.common.IMC;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityHellHound
extends EntityTameable {
    private float headRotationCourse;
    private float headRotationCourseOld;
    private Block spawnableBlock;

    public EntityHellHound(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.8f);
        this.field_70728_aV = 10;
        this.field_70178_ae = true;
        this.spawnableBlock = Blocks.field_150424_aL;
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIApproachAndAttack((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIHellHoundBeg(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHellHoundNearestAttackablePlayer(this));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, 10, false));
        this.func_70903_f(false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70629_bd() {
        super.func_70629_bd();
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Float(this.func_110143_aJ()));
        this.field_70180_af.func_75682_a(19, (Object)new Byte(0));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_145780_a(int x, int y, int z, Block blockIn) {
        this.func_85030_a("mob.wolf.step", 0.15f, 1.0f);
    }

    public int func_70627_aG() {
        return 200;
    }

    protected String func_70639_aQ() {
        return this.func_70909_n() && this.field_70180_af.func_111145_d(18) < 10.0f && this.field_70146_Z.nextInt(3) == 0 ? "mob.wolf.whine" : "mob.wolf.growl";
    }

    protected String func_70621_aR() {
        return "imc:mobs.hellhound-hit";
    }

    protected String func_70673_aS() {
        return "imc:mobs.hellhound-death";
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.field_70170_p.func_147439_a(i, j - 1, k) == this.spawnableBlock && this.field_70170_p.func_72883_k(i, j, k) > 8;
    }

    protected void func_70628_a(boolean b, int fortuneLevel) {
        if (fortuneLevel >= 0) {
            int i;
            for (i = Math.min(fortuneLevel, 1) + this.field_70146_Z.nextInt(2 + fortuneLevel); i > 0; --i) {
                this.func_145779_a(Items.field_151059_bz, 1);
            }
            for (i = Math.min(fortuneLevel, 1) + this.field_70146_Z.nextInt(3 + fortuneLevel); i > 0; --i) {
                this.func_145779_a(Items.field_151114_aO, 1);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse += ((this.isBegging() ? 1.0f : 0.0f) - this.headRotationCourse) * 0.4f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        return 0xF000F0;
    }

    public float func_70013_c(float partialTicks) {
        return 1.0f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 3 == 0) {
            this.field_70170_p.func_72869_a("flame", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, 0.0, 0.0, 0.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float f) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * f) * 0.15f * (float)Math.PI;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity;
        if (this.func_85032_ar()) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if ((entity = source.func_76346_g()) != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity target) {
        boolean flag;
        super.func_70652_k(target);
        double damage = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.func_70909_n()) {
            damage /= 2.0;
        }
        if (flag = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)damage)) {
            target.func_70015_d(3);
            if (target instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)target);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        IAttributeInstance damage = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (damage != null) {
            damage.func_111128_a(tamed ? 6.0 : 4.0);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (this.func_70909_n()) {
            ItemFood itemfood;
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemFood && (itemfood = (ItemFood)itemstack.func_77973_b()).func_77845_h() && this.field_70180_af.func_111145_d(18) < (float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b()) {
                this.func_70691_i((float)itemfood.func_150905_g(itemstack) * 1.5f);
                if (!player.field_71075_bZ.field_75098_d && --itemstack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.func_70778_a(null);
                this.func_70784_b(null);
                this.func_70624_b(null);
            }
        } else if (itemstack != null && itemstack.func_77973_b() == IMC.item_black_bone) {
            if (!player.field_71075_bZ.field_75098_d && --itemstack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.func_70778_a(null);
                    this.func_70784_b(null);
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
                    this.func_152115_b(player.func_110124_au().toString());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.func_70909_n() ? (0.55f - ((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() - this.field_70180_af.func_111145_d(18)) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return IMC.hell_hounds_breeding && stack != null && stack.func_77973_b() == IMC.item_black_bone;
    }

    public EntityHellHound createChild(EntityAgeable ageable) {
        EntityHellHound hound = new EntityHellHound(this.field_70170_p);
        String s = this.func_152113_b();
        if (s != null && s.trim().length() > 0) {
            hound.func_152115_b(s);
            hound.func_70903_f(true);
        }
        return hound;
    }

    public void setBegging(boolean beg) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)(beg ? 1 : 0)));
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this || !this.func_70909_n() || otherAnimal.getClass() != EntityHellHound.class) {
            return false;
        }
        EntityHellHound hound = (EntityHellHound)otherAnimal;
        return hound.func_70909_n() && !hound.func_70906_o() && this.func_70880_s() && hound.func_70880_s();
    }

    public boolean isBegging() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n() && this.field_70173_aa > 2400;
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (target instanceof EntityCreeper || target instanceof EntityGhast) {
            return false;
        }
        if (target instanceof EntityWolf && ((EntityWolf)target).func_70909_n() && ((EntityWolf)target).func_70902_q() == owner || target instanceof EntityHellHound && ((EntityHellHound)target).func_70909_n() && ((EntityHellHound)target).func_70902_q() == owner) {
            return false;
        }
        if (target instanceof EntityPlayer && owner instanceof EntityPlayer && ((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
            return false;
        }
        return !(target instanceof EntityHorse) || !((EntityHorse)target).func_110248_bS();
    }

    public boolean func_110164_bC() {
        return this.func_70909_n() && super.func_110164_bC();
    }
}

