/*
 * Decompiled with CFR 0.152.
 */
package imc.entities;

import cpw.mods.fml.common.FMLLog;
import imc.ai.EntityAIApproachAndAttack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class EntityPigman
extends EntityCreature
implements IMerchant {
    private static final List<PigmanTrade> tradeList;
    private short angerCountdown;
    private short timeUntilReset;
    private boolean needsInitialization;
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private String playerToAttack = "";

    public EntityPigman(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIApproachAndAttack(this, 0.9, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public void func_70636_d() {
        if (this.angerCountdown > 0) {
            this.angerCountdown = (short)(this.angerCountdown - 1);
            if (this.angerCountdown == 0) {
                this.func_70624_b(null);
            } else if (this.func_70638_az() == null && !this.playerToAttack.isEmpty() && this.field_70170_p.func_72924_a(this.playerToAttack) != null) {
                this.func_70624_b((EntityLivingBase)this.field_70170_p.func_72924_a(this.playerToAttack));
            }
        }
        super.func_70636_d();
    }

    public void func_70624_b(EntityLivingBase entity) {
        this.playerToAttack = entity != null && entity instanceof EntityPlayer ? entity.func_70005_c_() : "";
        this.func_70784_b((Entity)entity);
        super.func_70624_b(entity);
    }

    protected Entity func_70782_k() {
        return this.angerCountdown == 0 ? null : this.func_70638_az();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData livingdata) {
        this.func_70062_b(0, new ItemStack(Items.field_151010_B));
        return super.func_110161_a(livingdata);
    }

    private void becomeAngryAt(EntityLivingBase target) {
        this.func_70624_b(target);
        this.angerCountdown = (short)(350 + this.field_70146_Z.nextInt(80));
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!(source.func_76346_g() == null || !(source.func_76346_g() instanceof EntityLivingBase) || source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d)) {
            List list = this.field_70170_p.func_72872_a(EntityPigman.class, this.field_70121_D.func_72314_b(25.0, 25.0, 25.0));
            for (int i = 0; i < list.size(); ++i) {
                ((EntityPigman)((Object)list.get(i))).becomeAngryAt((EntityLivingBase)source.func_76346_g());
            }
        }
        return super.func_70097_a(source, par2);
    }

    public boolean func_70652_k(Entity target) {
        boolean flag;
        FMLLog.getLogger().log(Level.INFO, "attackEntityAsMob");
        super.func_70652_k(target);
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (this.func_70694_bm() != null && this.func_70694_bm().func_77973_b() == Items.field_151010_B) {
            attackDamage -= Item.ToolMaterial.GOLD.func_78000_c();
        }
        if (target instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
            knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
        }
        if (flag = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            int fire;
            if (knockback > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fire = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(fire * 4);
            }
            if (target instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)target);
        }
        return flag;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 2 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public int func_70627_aG() {
        return 160;
    }

    protected String func_70639_aQ() {
        return "mob.pig.say";
    }

    protected String func_70621_aR() {
        return "mob.pig.say";
    }

    protected String func_70673_aS() {
        return "mob.pig.death";
    }

    protected void func_70628_a(boolean b, int fortuneLevel) {
        if (fortuneLevel >= 0) {
            for (int i = 1 + this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + fortuneLevel); i > 0; --i) {
                this.func_145779_a(this.func_70027_ad() ? Items.field_151157_am : Items.field_151147_al, 1);
            }
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_110164_bC() {
        return false;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74777_a("angerCountdown", this.angerCountdown);
        tag.func_74778_a("playerToAttack", this.playerToAttack);
        if (this.buyingList != null) {
            tag.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.angerCountdown = tag.func_74765_d("angerCountdown");
        this.playerToAttack = tag.func_74779_i("playerToAttack");
        if (tag.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = tag.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if ((itemstack == null || itemstack.func_77973_b() != Items.field_151063_bx) && this.func_70089_S() && this.buyingPlayer == null && this.func_70638_az() == null && !player.func_70093_af()) {
            if (!(this.field_70170_p.field_72995_K || this.buyingList != null && this.buyingList.size() <= 0)) {
                this.func_70932_a_(player);
                player.func_71030_a((IMerchant)this, this.func_94057_bL());
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    protected void func_70619_bc() {
        if (this.buyingPlayer == null && (this.timeUntilReset = (short)(this.timeUntilReset - 1)) <= 0 && this.needsInitialization) {
            if (this.buyingList.size() < 4) {
                this.populateBuyingList();
                this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 200, 0));
            }
            this.needsInitialization = false;
        }
        super.func_70619_bc();
    }

    public void func_70932_a_(EntityPlayer player) {
        this.buyingPlayer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
        this.buyingList = recipeList;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        if (recipe.func_77394_a().func_77973_b() instanceof ItemArmor) {
            this.func_70062_b(4 - ((ItemArmor)recipe.func_77394_a().func_77973_b()).field_77881_a, new ItemStack(recipe.func_77394_a().func_77973_b()));
        }
        this.func_85030_a(this.func_70639_aQ(), this.func_70599_aP() * 1.5f, this.func_70647_i());
        if (!recipe.func_82784_g()) {
            recipe.func_77399_f();
            boolean lastUse = false;
            int i = 3 + this.field_70146_Z.nextInt(4);
            if (recipe.func_82784_g()) {
                this.buyingList.remove((Object)recipe);
                lastUse = true;
            }
            if (lastUse || this.buyingList.size() == 0 || this.field_70146_Z.nextInt(8 - i) == 0) {
                this.timeUntilReset = (short)40;
                this.needsInitialization = true;
                i += 5;
            }
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
            }
        }
    }

    public void func_110297_a_(ItemStack stack) {
    }

    private void populateBuyingList() {
        MerchantRecipe r;
        int j;
        int i;
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            ArrayList<Integer> missingEquipments = new ArrayList<Integer>();
            block0: for (i = 0; i < 4; ++i) {
                if (this.func_130225_q(i) != null) continue;
                for (j = 0; j < this.buyingList.size(); ++j) {
                    r = (MerchantRecipe)this.buyingList.get(j);
                    Item item = r.func_77394_a().func_77973_b();
                    if (item instanceof ItemArmor && ((ItemArmor)item).field_77881_a == 3 - i) continue block0;
                }
                missingEquipments.add(i);
            }
            if (missingEquipments.size() > 0) {
                int slot = (Integer)missingEquipments.get(this.field_70146_Z.nextInt(missingEquipments.size()));
                this.buyingList.add((Object)new MerchantRecipe(new ItemStack(EntityPigman.func_82161_a((int)(1 + slot), (int)(1 + this.field_70146_Z.nextInt(3)))), null, new ItemStack(Items.field_151166_bC, (slot == 1 || slot == 2 ? 3 : 2) + this.field_70146_Z.nextInt(2))));
                return;
            }
        }
        ArrayList<Integer> missingTrades = new ArrayList<Integer>();
        block2: for (i = 0; i < tradeList.size(); ++i) {
            for (j = 0; j < this.buyingList.size(); ++j) {
                r = (MerchantRecipe)this.buyingList.get(j);
                if (!r.func_82784_g() && tradeList.get(i).correspondsTo(r)) continue block2;
            }
            missingTrades.add(i);
        }
        if (missingTrades.size() > 0) {
            tradeList.get((Integer)missingTrades.get(this.field_70146_Z.nextInt(missingTrades.size()))).modifyMerchantRecipeList(this.buyingList, this.field_70146_Z);
        }
    }

    static {
        Enchantment[] enchantmentList;
        tradeList = new ArrayList<PigmanTrade>();
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151025_P), 5, 8, new ItemStack(Items.field_151166_bC), 1, 1));
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151034_e), 7, 10, new ItemStack(Items.field_151166_bC), 1, 1));
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151127_ba), 12, 18, new ItemStack(Items.field_151166_bC), 1, 1));
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151166_bC), 7, 9, new ItemStack(Items.field_151075_bm), 2, 3));
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151166_bC), 3, 4, new ItemStack(Items.field_151073_bk), 1, 1));
        tradeList.add(new PigmanTrade(new ItemStack(Items.field_151166_bC), 1, 1, new ItemStack(Items.field_151016_H), 4, 5));
        for (Enchantment ench : enchantmentList = new Enchantment[]{Enchantment.field_77335_o, Enchantment.field_77338_j, Enchantment.field_77347_r}) {
            ItemStack enchantedSword = new ItemStack(Items.field_151010_B);
            enchantedSword.func_77966_a(ench, 2);
            tradeList.add(new PigmanTrade(new ItemStack(Items.field_151010_B), 1, 1, new ItemStack(Items.field_151166_bC), 5, 7, enchantedSword, 1, 1));
        }
    }

    private static class PigmanTrade
    implements ITradeList {
        private ItemStack buy1;
        private ItemStack buy2;
        private ItemStack sell;
        private int qBuy1Min;
        private int qBuy1Max;
        private int qBuy2Min;
        private int qBuy2Max;
        private int qSellMin;
        private int qSellMax;

        public PigmanTrade(ItemStack b, int qmin, int qmax, ItemStack s, int smin, int smax) {
            this(b, qmin, qmax, null, 0, 0, s, smin, smax);
        }

        public PigmanTrade(ItemStack b1, int q1min, int q1max, ItemStack b2, int q2min, int q2max, ItemStack s, int smin, int smax) {
            this.buy1 = b1;
            this.qBuy1Min = q1min;
            this.qBuy1Max = q1max;
            this.buy2 = b2;
            this.qBuy2Min = q2min;
            this.qBuy2Max = q2max;
            this.sell = s;
            this.qSellMin = smin;
            this.qSellMax = smax;
        }

        public boolean correspondsTo(MerchantRecipe recipe) {
            if (recipe.func_77394_a().func_77973_b() != this.buy1.func_77973_b() || recipe.func_77394_a().func_77960_j() != this.buy1.func_77960_j()) {
                return false;
            }
            if (this.buy2 == null != (recipe.func_77396_b() == null)) {
                return false;
            }
            if (this.buy2 != null && (recipe.func_77396_b().func_77973_b() != this.buy2.func_77973_b() || recipe.func_77396_b().func_77960_j() != this.buy2.func_77960_j())) {
                return false;
            }
            return recipe.func_77397_d().func_77973_b() == this.sell.func_77973_b() && recipe.func_77397_d().func_77960_j() == this.sell.func_77960_j();
        }

        @Override
        public void modifyMerchantRecipeList(MerchantRecipeList recipeList, Random rand) {
            ItemStack b1 = this.buy1.func_77946_l();
            ItemStack b2 = null;
            ItemStack s = this.sell.func_77946_l();
            b1.field_77994_a = this.qBuy1Min + rand.nextInt(this.qBuy1Max - this.qBuy1Min + 1);
            if (this.buy2 != null) {
                b2 = this.buy2.func_77946_l();
                b2.field_77994_a = this.qBuy2Min + rand.nextInt(this.qBuy2Max - this.qBuy2Min + 1);
            }
            s.field_77994_a = this.qSellMin + rand.nextInt(this.qSellMax - this.qSellMin + 1);
            recipeList.add((Object)new MerchantRecipe(b1, b2, s));
        }
    }

    public static interface ITradeList {
        public void modifyMerchantRecipeList(MerchantRecipeList var1, Random var2);
    }
}

