/*
 * Decompiled with CFR 0.152.
 */
package imc.handlers;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import imc.common.IMC;
import imc.items.ItemMachete;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockSapling;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.world.BlockEvent;

public class BlockHandler {
    @SubscribeEvent
    public void onBlockHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        Block block = event.block;
        if (IMC.dead_bushes_drop_sticks && block == Blocks.field_150330_I && (event.harvester == null || event.harvester != null && !event.harvester.field_71075_bZ.field_75098_d || !event.isSilkTouching && event.harvester != null && event.harvester.func_70694_bm() != null && event.harvester.func_70694_bm().func_77973_b() != Items.field_151097_aZ)) {
            event.drops.clear();
            event.drops.add(new ItemStack(Items.field_151055_y, event.world.field_73012_v.nextInt(2)));
        } else if (IMC.boats_never_break_on_lilypads && event.block instanceof BlockLilyPad) {
            List list = event.world.func_72872_a(EntityBoat.class, AxisAlignedBB.func_72330_a((double)(event.x - 1), (double)(event.y - 1), (double)(event.z - 1), (double)(event.x + 1), (double)(event.y + 1), (double)(event.z + 1)));
            for (int i = 0; i < list.size(); ++i) {
                ((EntityBoat)list.get((int)i)).field_70159_w = 0.0;
                ((EntityBoat)list.get((int)i)).field_70179_y = 0.0;
            }
        } else if (IMC.bookshelves_drop_themselves && block == Blocks.field_150342_X) {
            event.drops.clear();
            event.drops.add(new ItemStack(Blocks.field_150342_X));
        } else if (IMC.leaves_drop_sticks && block instanceof BlockLeavesBase && (event.harvester == null || !event.harvester.field_71075_bZ.field_75098_d)) {
            if (!event.isSilkTouching) {
                int chance = IMC.leaves_drop_sticks_chance;
                if (event.fortuneLevel > 0 && (chance *= 1 << event.fortuneLevel) > 40) {
                    chance = 40;
                }
                event.dropChance = (float)chance / 100.0f;
                event.drops.add(new ItemStack(Items.field_151055_y));
            }
        } else if (IMC.logs_cant_be_harvested_with_bare_hands && (block == Blocks.field_150364_r || block == Blocks.field_150363_s) && event.harvester != null && !event.harvester.field_71075_bZ.field_75098_d) {
            int harvestLevel;
            ItemStack tool = event.harvester.func_70694_bm();
            int n = tool == null ? -1 : (harvestLevel = tool.func_77973_b() instanceof ItemMachete ? ((ItemMachete)tool.func_77973_b()).toolMaterial.func_77996_d() : tool.func_77973_b().getHarvestLevel(tool, "axe"));
            if (harvestLevel < 0) {
                event.drops.clear();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockHarvestDropsLowest(BlockEvent.HarvestDropsEvent event) {
        if (IMC.autosmelting_enchantment_on_tools && event.harvester != null && event.harvester.func_70694_bm() != null && EnchantmentHelper.func_77506_a((int)IMC.enchantment_autosmelting.field_77352_x, (ItemStack)event.harvester.func_70694_bm()) > 0) {
            for (int i = 0; i < event.drops.size(); ++i) {
                ItemStack stack;
                if (event.drops.get(i) == null || (stack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)event.drops.get(i))) == null) continue;
                event.drops.set(i, new ItemStack(stack.func_77973_b(), ((ItemStack)event.drops.get((int)i)).field_77994_a * stack.field_77994_a, stack.func_77960_j()));
            }
        }
    }

    @SubscribeEvent
    public void onBonemealUse(BonemealEvent event) {
        Block block;
        if (event.world.field_72995_K || event.block == null) {
            return;
        }
        if (IMC.bonemeal_works_on_sugar_cane && event.block == Blocks.field_150436_aH) {
            Block top;
            BlockPos pos2 = new BlockPos(event.x, event.y, event.z);
            while ((top = event.world.func_147439_a((pos2 = pos2.up()).getX(), pos2.getY(), pos2.getZ())) == Blocks.field_150436_aH) {
            }
            if (top.func_149688_o().func_76222_j()) {
                event.world.func_147465_d(pos2.getX(), pos2.getY(), pos2.getZ(), Blocks.field_150436_aH, 0, 3);
                event.setResult(Event.Result.ALLOW);
            }
        } else if (IMC.bonemeal_works_on_cactus && event.block == Blocks.field_150434_aF) {
            Block top;
            BlockPos pos2 = new BlockPos(event.x, event.y, event.z);
            while ((top = event.world.func_147439_a((pos2 = pos2.up()).getX(), pos2.getY(), pos2.getZ())) == Blocks.field_150434_aF) {
            }
            if (top.func_149688_o().func_76222_j()) {
                event.world.func_147465_d(pos2.getX(), pos2.getY(), pos2.getZ(), Blocks.field_150434_aF, 0, 3);
                event.setResult(Event.Result.ALLOW);
            }
        } else if (IMC.bonemeal_clones_lilypads && event.block == Blocks.field_150392_bi) {
            EntityItem item = new EntityItem(event.world, (double)event.x, (double)event.y + 0.3, (double)event.z, new ItemStack(Blocks.field_150392_bi));
            event.world.func_72838_d((Entity)item);
            event.setResult(Event.Result.ALLOW);
        } else if (IMC.one_bonemeal_per_sapling && event.block == Blocks.field_150345_g) {
            BlockSapling sap = (BlockSapling)event.block;
            sap.func_149878_d(event.world, event.x, event.y, event.z, event.world.field_73012_v);
            event.setResult(Event.Result.ALLOW);
        } else if (IMC.all_crops_need_only_one_bonemeal && (block = event.block) instanceof BlockBush && ((BlockBush)block).getPlantType(null, 0, 0, 0) == EnumPlantType.Crop && event.world.func_72805_g(event.x, event.y, event.z) < 7) {
            event.world.func_72921_c(event.x, event.y, event.z, 7, 3);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack stack;
        if (IMC.silk_touch_harvests_mob_spawners && event.block instanceof BlockMobSpawner && event.getPlayer() != null && !event.getPlayer().field_71075_bZ.field_75098_d && (stack = event.getPlayer().func_70694_bm()) != null && stack.func_77973_b() instanceof ItemPickaxe && EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)stack) > 0 && (!IMC.silk_touch_harvests_mob_spawners_feature_needs_golden_pickaxe || stack.func_77973_b() == Items.field_151005_D)) {
            EntityItem drop = new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, new ItemStack(IMC.block_mob_spawner));
            if (event.world.func_147438_o(event.x, event.y, event.z) != null && event.world.func_147438_o(event.x, event.y, event.z) instanceof TileEntityMobSpawner) {
                TileEntityMobSpawner te = (TileEntityMobSpawner)event.world.func_147438_o(event.x, event.y, event.z);
                drop.func_92059_d().field_77990_d = new NBTTagCompound();
                drop.func_92059_d().field_77990_d.func_74778_a("EntityId", te.func_145881_a().func_98276_e());
                event.world.func_72838_d((Entity)drop);
                event.setExpToDrop(0);
            }
        }
        if (IMC.arrows_drop_when_block_broken) {
            List list = event.world.func_72872_a(EntityArrow.class, AxisAlignedBB.func_72330_a((double)(event.x - 1), (double)(event.y - 1), (double)(event.z - 1), (double)(event.x + 2), (double)(event.y + 2), (double)(event.z + 2)));
            for (int i = 0; i < list.size(); ++i) {
                EntityArrow arrow = (EntityArrow)list.get(i);
                arrow.func_70014_b(arrow.getEntityData());
                if (arrow.getEntityData().func_74771_c("inGround") == 0 || arrow.getEntityData().func_74765_d("xTile") != event.x || arrow.getEntityData().func_74765_d("yTile") != event.y || arrow.getEntityData().func_74765_d("zTile") != event.z) continue;
                if (!event.world.field_72995_K && arrow.field_70249_b <= 0 && arrow.field_70251_a == 1) {
                    EntityItem drop = new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, new ItemStack(Items.field_151032_g));
                    event.world.func_72838_d((Entity)drop);
                }
                arrow.func_70106_y();
            }
        }
    }
}

