/*
 * Decompiled with CFR 0.152.
 */
package imc.handlers;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import imc.common.IMC;
import imc.common.IMCReflection;
import imc.entities.EntityIMCArrow;
import imc.entities.EntityMiningTNTPrimed;
import imc.entities.EntityPigman;
import imc.entities.EntityWildPig;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EntityLivingHandler {
    private static List<Block> doorBlocks = Arrays.asList(Blocks.field_150466_ao);
    public static List<Item> shovels = Arrays.asList(Items.field_151051_r, Items.field_151037_a, Items.field_151011_C, Items.field_151047_v, IMC.item_flint_spade, IMC.item_adamantium_shovel);

    @SubscribeEvent
    public void onEntityLivingDeath(LivingDeathEvent event) {
        int min;
        EntityLivingBase entityLiving = event.entityLiving;
        if (entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (IMC.retrieve_arrows_on_mobs && entityLiving.getEntityData().func_74764_b("arrows_dropped")) {
            entityLiving.func_145779_a(Items.field_151032_g, entityLiving.getEntityData().func_74762_e("arrows_dropped"));
        }
        if (IMC.bats_drop_leather && entityLiving instanceof EntityBat) {
            entityLiving.func_145779_a(Items.field_151116_aA, 1);
        } else if (IMC.wolves_drop_leather && entityLiving instanceof EntityWolf) {
            entityLiving.func_145779_a(Items.field_151116_aA, 1 + entityLiving.func_70681_au().nextInt(2));
        } else if (IMC.mutton_horse_and_squid_meat && !IMC.pda_installed && entityLiving instanceof EntityHorse) {
            if (!entityLiving.func_70631_g_() && entityLiving.func_70681_au().nextInt(100) < IMC.horse_meat_drop_chance) {
                int n;
                int max = IMC.horse_meat_drop_max;
                min = IMC.horse_meat_drop_min;
                if (max < min) {
                    max = min = (min + max) / 2;
                }
                if ((n = min + entityLiving.func_70681_au().nextInt(max - min + 1)) > 0) {
                    entityLiving.func_145779_a(IMC.item_raw_horse, n);
                }
            }
        } else if (IMC.mutton_horse_and_squid_meat && !IMC.pda_installed && entityLiving instanceof EntitySquid) {
            if (entityLiving.func_70681_au().nextInt(100) < IMC.squid_meat_drop_chance) {
                int n;
                int max = IMC.squid_meat_drop_max;
                min = IMC.squid_meat_drop_min;
                if (max < min) {
                    max = min = (min + max) / 2;
                }
                if ((n = min + entityLiving.func_70681_au().nextInt(max - min + 1)) > 0) {
                    entityLiving.func_145779_a(IMC.item_raw_squid, n);
                }
            }
        } else if (IMC.witches_drop_potions && entityLiving instanceof EntityWitch) {
            for (int i = entityLiving.func_70681_au().nextInt(3); i > 0; --i) {
                ItemStack potion = new ItemStack((Item)Items.field_151068_bn);
                int effet = 1 + entityLiving.func_70681_au().nextInt(7);
                if (effet >= 4) {
                    ++effet;
                }
                if (effet == 7) {
                    effet = 9;
                }
                if (effet == 8) {
                    effet = 13;
                }
                potion.func_77964_b(effet);
                entityLiving.func_70099_a(potion, 0.0f);
            }
        } else if (IMC.pigs_can_drop_leather && entityLiving instanceof EntityPig && entityLiving.func_70681_au().nextInt(100) < IMC.pig_drop_leather_chance && (entityLiving.getClass() != EntityWildPig.class || entityLiving.func_70681_au().nextInt(3) != 0)) {
            entityLiving.func_145779_a(Items.field_151116_aA, 1);
        }
        if (IMC.mobs_drop_skulls && entityLiving instanceof EntitySkeleton && ((EntitySkeleton)entityLiving).func_82202_m() != 1 && entityLiving.func_70681_au().nextInt(100) < IMC.mob_drop_skull_chance) {
            entityLiving.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
        } else if (IMC.mobs_drop_skulls && entityLiving instanceof EntityZombie && !(entityLiving instanceof EntityPigZombie) && entityLiving.func_70681_au().nextInt(100) < IMC.mob_drop_skull_chance) {
            entityLiving.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 2), 0.0f);
        } else if (IMC.mobs_drop_skulls && entityLiving instanceof EntityCreeper && entityLiving.func_70681_au().nextInt(100) < IMC.mob_drop_skull_chance) {
            entityLiving.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
        } else if (IMC.players_drop_heads && entityLiving instanceof EntityPlayer && entityLiving.func_70681_au().nextInt(100) < IMC.player_drop_head_chance) {
            ItemStack head = new ItemStack(Items.field_151144_bL, 1, 3);
            head.func_77982_d(new NBTTagCompound());
            head.func_77978_p().func_74778_a("SkullOwner", ((EntityPlayer)entityLiving).getDisplayName());
            entityLiving.func_70099_a(head, 0.0f);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        int i;
        EntityLivingBase entityLiving = event.entityLiving;
        if (entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (IMC.dropped_items_less_damaged && entityLiving instanceof EntityLiving && !(entityLiving instanceof EntityPlayer) && !((EntityLiving)entityLiving).func_104002_bU()) {
            for (i = 0; i < event.drops.size(); ++i) {
                ItemStack item = ((EntityItem)event.drops.get(i)).func_92059_d();
                if (!(item.func_77973_b() instanceof ItemTool) && !(item.func_77973_b() instanceof ItemSword) && !(item.func_77973_b() instanceof ItemArmor) && !(item.func_77973_b() instanceof ItemBow) || item.func_77960_j() <= 0) continue;
                int n = item.func_77958_k() / 2;
                if (n < 1) {
                    n = 1;
                }
                item.func_77964_b(entityLiving.func_70681_au().nextInt(n));
            }
        }
        if (IMC.endermen_always_drop && entityLiving instanceof EntityEnderman) {
            if (event.drops.isEmpty()) {
                event.drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(Items.field_151079_bi)));
            }
        } else if (IMC.creepers_can_drop_tnt && entityLiving instanceof EntityCreeper) {
            if (entityLiving.func_70681_au().nextInt(100) < IMC.creeper_drop_tnt_chance) {
                event.drops.clear();
                event.drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(Blocks.field_150335_W)));
            }
        } else if (IMC.spiders_can_drop_cobweb && entityLiving instanceof EntitySpider) {
            if (entityLiving.func_70681_au().nextInt(100) < IMC.spider_drop_cobweb_chance) {
                event.drops.clear();
                event.drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(Blocks.field_150321_G)));
            }
        } else if (entityLiving instanceof EntitySkeleton && ((EntitySkeleton)entityLiving).func_82202_m() == 1) {
            if (IMC.obsidian_sword) {
                for (i = 0; i < event.drops.size(); ++i) {
                    if (((EntityItem)event.drops.get(i)).func_92059_d().func_77973_b() != IMC.item_obsidian_sword) continue;
                    event.drops.remove(i);
                }
                if (entityLiving.func_70681_au().nextInt(100) < IMC.obsidian_sword_drop_chance_on_wither_skeleton) {
                    event.drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(IMC.item_obsidian_sword, 1, entityLiving.func_70681_au().nextInt(IMC.item_obsidian_sword.func_77612_l() / 2))));
                }
            }
            if (IMC.wither_skeletons_drop_black_bones && entityLiving.func_70681_au().nextInt(100) < IMC.wither_skeleton_drop_black_bone_chance) {
                event.drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(IMC.item_black_bone)));
            }
        } else if (IMC.zombie_pigmen_drop_cooked_porkchops && entityLiving instanceof EntityPigZombie) {
            for (i = 0; i < event.drops.size(); ++i) {
                if (((EntityItem)event.drops.get(i)).func_92059_d().func_77973_b() != Items.field_151078_bh) continue;
                ((EntityItem)event.drops.get(i)).func_92058_a(new ItemStack(Items.field_151157_am, ((EntityItem)event.drops.get((int)i)).func_92059_d().field_77994_a));
            }
        } else if (IMC.iron_golems_drop_iron_blocks && entityLiving instanceof EntityIronGolem) {
            for (i = 1 + entityLiving.func_70681_au().nextInt(2); i > 0; --i) {
                event.drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, new ItemStack(Blocks.field_150339_S)));
            }
        }
        if (IMC.fireballs_cook_drops && event.source.func_76364_f() != null && event.source.func_76364_f() instanceof EntitySmallFireball) {
            for (i = 0; i < event.drops.size(); ++i) {
                ItemStack stack;
                ItemStack drop = ((EntityItem)event.drops.get(i)).func_92059_d();
                if (drop == null || drop.func_77975_n() != EnumAction.eat || (stack = FurnaceRecipes.func_77602_a().func_151395_a(drop)) == null) continue;
                ((EntityItem)event.drops.get(i)).func_92058_a(new ItemStack(stack.func_77973_b(), drop.field_77994_a * stack.field_77994_a, stack.func_77960_j()));
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving == null) {
            return;
        }
        if (IMC.obsidian_sword && event.entityLiving instanceof EntitySkeleton && ((EntitySkeleton)event.entityLiving).func_82202_m() == 1 && event.entityLiving.func_70694_bm() != null && event.entityLiving.func_70694_bm().func_77973_b() == Items.field_151052_q) {
            event.entityLiving.func_70062_b(0, new ItemStack(IMC.item_obsidian_sword));
        } else if (IMC.baby_zombies_burn && !event.entity.field_70170_p.field_72995_K && event.entityLiving instanceof EntityZombie && event.entityLiving.func_70631_g_() && event.entity.field_70170_p.func_72935_r()) {
            float f = event.entity.func_70013_c(1.0f);
            if (f > 0.5f && event.entityLiving.func_70681_au().nextFloat() * 30.0f < (f - 0.4f) * 2.0f && event.entity.field_70170_p.func_72937_j((int)event.entity.field_70165_t, (int)Math.round(event.entity.field_70163_u), (int)event.entity.field_70161_v)) {
                boolean flag = true;
                ItemStack itemstack = event.entityLiving.func_71124_b(4);
                if (itemstack != null) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_77964_b(itemstack.func_77960_j() + event.entityLiving.func_70681_au().nextInt(2));
                        if (itemstack.func_77960_j() >= itemstack.func_77958_k()) {
                            event.entityLiving.func_70669_a(itemstack);
                            event.entityLiving.func_70062_b(4, (ItemStack)null);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    event.entityLiving.func_70015_d(8);
                }
            }
        } else if (IMC.chickens_leave_feathers && event.entityLiving instanceof EntityChicken && !event.entityLiving.func_70631_g_() && !event.entityLiving.field_70170_p.field_72995_K) {
            if (!event.entityLiving.getEntityData().func_74764_b("time_until_next_feather")) {
                int n = 2 * IMC.chicken_feather_rarity / 3;
                if (n < 1) {
                    n = 1;
                }
                event.entityLiving.getEntityData().func_74768_a("time_until_next_feather", n + event.entityLiving.func_70681_au().nextInt(n));
            } else {
                int time = event.entityLiving.getEntityData().func_74762_e("time_until_next_feather") - 1;
                if (time <= 0) {
                    int n = 2 * IMC.chicken_feather_rarity / 3;
                    if (n < 1) {
                        n = 1;
                    }
                    event.entityLiving.func_145779_a(Items.field_151008_G, 1);
                    event.entityLiving.getEntityData().func_74768_a("time_until_next_feather", n + event.entityLiving.func_70681_au().nextInt(n));
                } else {
                    event.entityLiving.getEntityData().func_74768_a("time_until_next_feather", time);
                }
            }
        } else if (IMC.cure_zombie_pigmen && event.entityLiving.getClass() == EntityPigZombie.class && !event.entityLiving.field_70170_p.field_72995_K) {
            EntityPigZombie pigZombie = (EntityPigZombie)event.entityLiving;
            if (pigZombie.func_82230_o() && IMCReflection.getConversionTime((EntityZombie)pigZombie) <= 1000) {
                EntityPigman pigman = new EntityPigman(pigZombie.field_70170_p);
                pigman.func_82149_j((Entity)pigZombie);
                pigman.func_110161_a(null);
                for (int i = 0; i <= 4; ++i) {
                    pigman.func_70062_b(i, pigZombie.func_71124_b(i));
                }
                if (pigZombie.func_94057_bL() != "") {
                    pigman.func_94058_c(pigZombie.func_94057_bL());
                    pigman.func_94061_f(pigZombie.func_94062_bN());
                }
                pigZombie.field_70170_p.func_72900_e((Entity)pigZombie);
                pigman.field_70170_p.func_72838_d((Entity)pigman);
                pigman.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 0));
                pigman.field_70170_p.func_72889_a((EntityPlayer)null, 1017, (int)pigman.field_70165_t, (int)pigman.field_70163_u, (int)pigman.field_70161_v, 0);
            }
        } else if (IMC.water_walking_enchantment_on_boots && event.entityLiving instanceof EntityPlayer && !event.entityLiving.field_70122_E && ((EntityPlayer)event.entityLiving).func_82169_q(0) != null && EnchantmentHelper.func_77506_a((int)IMC.enchantment_water_walking.field_77352_x, (ItemStack)((EntityPlayer)event.entityLiving).func_82169_q(0)) > 0) {
            AxisAlignedBB box = event.entityLiving.field_70121_D;
            if (event.entityLiving.field_70170_p.func_72830_b(box.func_72331_e(0.0, 0.1, 0.0), Material.field_151586_h)) {
                if (event.entityLiving.field_70181_x < 0.0) {
                    event.entityLiving.field_70181_x = 0.0;
                }
                event.entityLiving.field_70181_x += 0.02;
                event.entityLiving.field_70143_R = 0.0f;
            } else if (event.entityLiving.field_70170_p.func_72830_b(box.func_72314_b(0.0, 0.02, 0.0), Material.field_151586_h)) {
                event.entityLiving.field_70122_E = true;
                event.entityLiving.field_70181_x = 0.0;
                event.entityLiving.field_70143_R = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (IMC.retrieve_arrows_on_mobs && event.source.func_76364_f() instanceof EntityArrow && event.source.func_76346_g() instanceof EntityPlayer && ((EntityArrow)event.source.func_76364_f()).field_70251_a == 1 && event.entityLiving.func_70681_au().nextInt(100) < IMC.retrieve_arrow_chance) {
            if (event.entityLiving.getEntityData().func_74764_b("arrows_dropped")) {
                event.entityLiving.getEntityData().func_74768_a("arrows_dropped", event.entityLiving.getEntityData().func_74762_e("arrows_dropped") + 1);
            } else {
                event.entityLiving.getEntityData().func_74768_a("arrows_dropped", 1);
            }
        }
        if (IMC.health_draining_enchantment_on_swords && event.source.func_76364_f() instanceof EntityPlayer && event.source.func_76346_g() instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_70694_bm()) != null && EnchantmentHelper.func_77506_a((int)IMC.enchantment_health_draining.field_77352_x, (ItemStack)stack) > 0) {
            int amount = EnchantmentHelper.func_77506_a((int)IMC.enchantment_health_draining.field_77352_x, (ItemStack)stack);
            event.entityLiving.func_70097_a(DamageSource.field_76376_m, (float)amount);
            player.func_70691_i((float)amount);
        }
        if (IMC.poisoned_arrows && event.source.func_76364_f() instanceof EntityIMCArrow && event.source.func_76346_g() != null && ((EntityIMCArrow)event.source.func_76364_f()).isPoisoned()) {
            event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 20 * IMC.poisoned_arrows_effect_duration));
        }
        if (IMC.fire_and_explosions_can_ignite_creepers && event.entityLiving instanceof EntityCreeper && (event.source.func_76347_k() || event.source.func_94541_c()) && event.entityLiving.func_70681_au().nextInt(100) < IMC.fire_and_explosions_ignite_creeper_chance) {
            ((EntityCreeper)event.entityLiving).func_146079_cb();
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(EntityInteractEvent event) {
        ItemStack stack;
        if (IMC.pigs_have_more_breeding_items && event.target instanceof EntityPig) {
            EntityPig pig = (EntityPig)event.target;
            ItemStack itemstack = event.entityPlayer.field_71071_by.func_70448_g();
            if (!(itemstack == null || itemstack.func_77973_b() != Items.field_151174_bG && itemstack.func_77973_b() != Items.field_151034_e && itemstack.func_77973_b() != Items.field_151127_ba && itemstack.func_77973_b() != Items.field_151025_P || pig.func_70874_b() != 0 || pig.func_70880_s())) {
                if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                    if (itemstack.field_77994_a <= 0) {
                        event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                }
                pig.func_146082_f(event.entityPlayer);
                event.setCanceled(true);
            }
        } else if (IMC.cure_zombie_pigmen && event.target.getClass() == EntityPigZombie.class) {
            EntityPigZombie pigZombie = (EntityPigZombie)event.target;
            ItemStack stack2 = event.entityPlayer.func_70694_bm();
            if (stack2 != null && stack2.func_77973_b() == Items.field_151153_ao && stack2.func_77960_j() == 0 && !pigZombie.func_70631_g_() && !pigZombie.func_82230_o() && pigZombie.func_70644_a(Potion.field_76437_t)) {
                if (!event.entityPlayer.field_71075_bZ.field_75098_d && --stack2.field_77994_a <= 0) {
                    event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, null);
                }
                if (!pigZombie.field_70170_p.field_72995_K) {
                    try {
                        IMCReflection.startConversion((EntityZombie)pigZombie, pigZombie.func_70681_au().nextInt(2401) + 4600);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                event.setCanceled(true);
            }
        } else if (IMC.defuse_tnt_with_shears && (event.target.getClass() == EntityTNTPrimed.class || event.target.getClass() == EntityMiningTNTPrimed.class) && (stack = event.entityPlayer.func_70694_bm()) != null && stack.func_77973_b() == Items.field_151097_aZ) {
            if (!event.target.field_70170_p.field_72995_K) {
                event.target.func_85030_a("mob.sheep.shear", 1.0f, 1.0f);
                event.target.func_145779_a(Item.func_150898_a((Block)(event.target.getClass() == EntityMiningTNTPrimed.class ? IMC.block_mining_tnt : Blocks.field_150335_W)), 1);
            }
            event.entityPlayer.func_70694_bm().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
            event.target.field_70170_p.func_72900_e(event.target);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        BlockPos pos = new BlockPos(event.x, event.y, event.z);
        if (IMC.dangerous_fire && !event.entityPlayer.field_71075_bZ.field_75098_d && event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            if (event.entityPlayer.func_70694_bm() != null && shovels.contains(event.entityPlayer.func_70694_bm().func_77973_b())) {
                return;
            }
            BlockPos pos2 = pos.offset(EnumFacing.values()[event.face]);
            if (BlockPos.getBlockAt(event.world, pos2) == Blocks.field_150480_ab) {
                event.useBlock = Event.Result.DENY;
                if (event.entityPlayer.func_70694_bm() == null && event.world.field_73012_v.nextInt(4) == 0) {
                    event.entityPlayer.func_70015_d(3);
                }
                return;
            }
        }
        Block block = BlockPos.getBlockAt(event.world, pos);
        int meta = BlockPos.getMetaAt(event.world, pos);
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && block == Blocks.field_150383_bp) {
            BlockCauldron cauldron = (BlockCauldron)block;
            ItemStack itemstack = event.entityPlayer.field_71071_by.func_70448_g();
            if (itemstack == null) {
                return;
            }
            int i = BlockCauldron.func_150027_b((int)meta);
            if (IMC.cauldrons_have_infinite_water && itemstack.func_77973_b() == Items.field_151069_bo && i > 0) {
                if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                    ItemStack itemstack1 = new ItemStack((Item)Items.field_151068_bn, 1, 0);
                    --itemstack.field_77994_a;
                    if (itemstack.field_77994_a <= 0) {
                        event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, itemstack1);
                        ((EntityPlayerMP)event.entityPlayer).func_71120_a(event.entityPlayer.field_71069_bz);
                    } else if (!event.entityPlayer.field_71071_by.func_70441_a(itemstack1)) {
                        event.world.func_72838_d((Entity)new EntityItem(event.world, (double)event.x + 0.5, (double)event.y + 1.5, (double)event.z + 0.5, itemstack1));
                    } else if (event.entityPlayer instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)event.entityPlayer).func_71120_a(event.entityPlayer.field_71069_bz);
                    }
                }
                event.world.func_147453_f(event.x, event.y, event.z, block);
                event.useBlock = Event.Result.DENY;
            } else if (IMC.cauldrons_have_infinite_water && i > 0 && itemstack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemstack.func_77973_b()).func_82812_d() == ItemArmor.ArmorMaterial.CLOTH) {
                ItemArmor itemarmor = (ItemArmor)itemstack.func_77973_b();
                itemarmor.func_82815_c(itemstack);
                event.world.func_147453_f(event.x, event.y, event.z, block);
                event.useBlock = Event.Result.DENY;
            } else if (IMC.fill_up_bucket_from_cauldron && i == 3 && (itemstack.func_77973_b() == Items.field_151133_ar || itemstack.func_77973_b() == IMC.item_wooden_bucket)) {
                if (!IMC.cauldrons_have_infinite_water) {
                    cauldron.func_150024_a(event.world, event.x, event.y, event.z, 0);
                }
                ItemStack itemstack1 = new ItemStack(itemstack.func_77973_b() == IMC.item_wooden_bucket ? IMC.item_wooden_bucket_water : Items.field_151131_as);
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a <= 0) {
                    event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, itemstack1);
                    ((EntityPlayerMP)event.entityPlayer).func_71120_a(event.entityPlayer.field_71069_bz);
                } else if (!event.entityPlayer.field_71071_by.func_70441_a(itemstack1)) {
                    event.world.func_72838_d((Entity)new EntityItem(event.world, (double)event.x + 0.5, (double)event.y + 1.5, (double)event.z + 0.5, itemstack1));
                } else if (event.entityPlayer instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)event.entityPlayer).func_71120_a(event.entityPlayer.field_71069_bz);
                }
                event.useBlock = Event.Result.DENY;
            } else if (i < 3 && itemstack.func_77973_b() == IMC.item_wooden_bucket_water) {
                if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                    event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, new ItemStack(IMC.item_wooden_bucket));
                }
                cauldron.func_150024_a(event.world, event.x, event.y, event.z, 3);
            }
        } else if (IMC.double_doors_open_together && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && doorBlocks.contains(block)) {
            if (doorBlocks.contains(block)) {
                BlockPos door2Pos;
                Block doorBlock2;
                BlockPos doorPos = new BlockPos(event.x, event.y, event.z);
                int fullMeta = ((BlockDoor)block).func_150012_g((IBlockAccess)event.world, event.x, event.y, event.z);
                boolean isTop = (event.world.func_72805_g(event.x, event.y, event.z) & 8) != 0;
                int facing = fullMeta & 3;
                boolean open = (fullMeta & 4) != 0;
                boolean hinge = (fullMeta & 0x10) != 0;
                Vec3i vec = null;
                if (facing == 0) {
                    vec = new Vec3i(0, 0, 1);
                } else if (facing == 1) {
                    vec = new Vec3i(-1, 0, 0);
                } else if (facing == 2) {
                    vec = new Vec3i(0, 0, -1);
                } else if (facing == 3) {
                    vec = new Vec3i(1, 0, 0);
                }
                if (hinge) {
                    vec = new Vec3i(-vec.getX(), 0, -vec.getZ());
                }
                if (doorBlocks.contains(doorBlock2 = event.world.func_147439_a((door2Pos = doorPos.add(vec)).getX(), door2Pos.getY(), door2Pos.getZ()))) {
                    boolean hinge2;
                    int fullMeta2 = ((BlockDoor)doorBlock2).func_150012_g((IBlockAccess)event.world, door2Pos.getX(), door2Pos.getY(), door2Pos.getZ());
                    boolean isTop2 = (event.world.func_72805_g(door2Pos.getX(), door2Pos.getY(), door2Pos.getZ()) & 8) != 0;
                    int facing2 = fullMeta2 & 3;
                    boolean open2 = (fullMeta2 & 4) != 0;
                    boolean bl = hinge2 = (fullMeta2 & 0x10) != 0;
                    if (isTop == isTop2 && facing == facing2 && hinge != hinge2 && open == open2) {
                        doorBlock2.func_149727_a(event.world, door2Pos.getX(), door2Pos.getY(), door2Pos.getZ(), event.entityPlayer, 0, 0.0f, 0.0f, 0.0f);
                    }
                }
            }
        } else if (IMC.gunpowder_magma_cream_or_blaze_powder_make_nether_wart_grow && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && block == Blocks.field_150388_bm) {
            ItemStack itemstack = event.entityPlayer.field_71071_by.func_70448_g();
            int metaAge = event.world.func_72805_g(event.x, event.y, event.z);
            if (itemstack != null && (itemstack.func_77973_b() == Items.field_151016_H || itemstack.func_77973_b() == Items.field_151064_bs || itemstack.func_77973_b() == Items.field_151065_br) && metaAge < 3) {
                if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                    if (--itemstack.field_77994_a <= 0) {
                        event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    if (event.entityPlayer instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)event.entityPlayer).func_71120_a(event.entityPlayer.field_71069_bz);
                    }
                }
                if ((metaAge += 2) > 3) {
                    metaAge = 3;
                }
                event.world.func_72921_c(event.x, event.y, event.z, metaAge, 3);
                if (!event.world.field_72995_K) {
                    event.world.func_72926_e(2000, event.x, event.y, event.z, 4);
                }
                event.useBlock = Event.Result.DENY;
            }
        }
    }

    @SubscribeEvent
    public void onArrowNock(ArrowNockEvent event) {
        if (!IMC.poisoned_arrows) {
            return;
        }
        if (event.entityPlayer.func_70694_bm() != null && event.entityPlayer.field_71071_by.func_146028_b(IMC.item_poisoned_arrow)) {
            event.entityPlayer.func_71008_a(event.result, event.entityPlayer.func_70694_bm().func_77973_b().func_77626_a(event.result));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onArrowLoose(ArrowLooseEvent event) {
        boolean infiteBow;
        int j = event.charge;
        boolean bl = infiteBow = event.entityPlayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)event.bow) > 0;
        if (infiteBow || event.entityPlayer.field_71071_by.func_146028_b(Items.field_151032_g) || event.entityPlayer.field_71071_by.func_146028_b(IMC.item_poisoned_arrow)) {
            int l;
            int k;
            float f = (float)j / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityIMCArrow entityarrow = new EntityIMCArrow(event.entity.field_70170_p, (EntityLivingBase)event.entityPlayer, f * 2.0f);
            if (f == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            if ((k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)event.bow)) > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)k * 0.5 + 0.5);
            }
            if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)event.bow)) > 0) {
                entityarrow.func_70240_a(l);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)event.bow) > 0) {
                entityarrow.func_70015_d(100);
            }
            event.bow.func_77972_a(1, (EntityLivingBase)event.entityPlayer);
            event.entity.field_70170_p.func_72956_a((Entity)event.entityPlayer, "random.bow", 1.0f, 1.0f / (event.entityLiving.func_70681_au().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            boolean poisonFlag = IMC.poisoned_arrows && event.entityPlayer.field_71071_by.func_146028_b(IMC.item_poisoned_arrow);
            entityarrow.setPoisoned(poisonFlag);
            if (infiteBow) {
                entityarrow.field_70251_a = 2;
            } else if (poisonFlag) {
                event.entityPlayer.field_71071_by.func_146026_a(IMC.item_poisoned_arrow);
            } else {
                event.entityPlayer.field_71071_by.func_146026_a(Items.field_151032_g);
            }
            if (!event.entity.field_70170_p.field_72995_K) {
                event.entity.field_70170_p.func_72838_d((Entity)entityarrow);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTryToBreakBlock(PlayerEvent.BreakSpeed event) {
        if (IMC.cacti_hurt_hands && !event.entityPlayer.field_70170_p.field_72995_K && event.block == Blocks.field_150434_aF && event.entityPlayer.func_70694_bm() == null) {
            event.entityPlayer.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }
}

