/*
 * Decompiled with CFR 0.152.
 */
package imc.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import imc.common.IMC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class TickHandler {
    public static AttributeModifier[] health_bonus = new AttributeModifier[]{new AttributeModifier("Health Bonus 1", 2.0, 0).func_111168_a(false), new AttributeModifier("Health Bonus 2", 4.0, 0).func_111168_a(false), new AttributeModifier("Health Bonus 3", 6.0, 0).func_111168_a(false)};
    private static AttributeModifier speed_bonus = new AttributeModifier("Speed Bonus 1", (double)0.02f, 0).func_111168_a(false);
    public static Map<World, List<Entity>> entitiesToSpawn = new HashMap<World, List<Entity>>();
    public static List<IRecipe> recipesToRemove = new ArrayList<IRecipe>();

    public static void addEntityToSpawn(World world, Entity entity) {
        if (entitiesToSpawn.containsKey(world)) {
            entitiesToSpawn.get(world).add(entity);
        } else {
            ArrayList<Entity> list = new ArrayList<Entity>();
            list.add(entity);
            entitiesToSpawn.put(world, list);
        }
    }

    public static void updateHealthBonus(EntityPlayer player, boolean updateHealth) {
        ItemStack stack;
        int toApply = -1;
        float currentHealth = player.func_110143_aJ();
        if (IMC.health_bonus_enchantment_on_chestplates && (stack = player.field_71071_by.func_70440_f(2)) != null) {
            toApply = EnchantmentHelper.func_77506_a((int)IMC.enchantment_health_bonus.field_77352_x, (ItemStack)stack) - 1;
        }
        Collection collection = ((ModifiableAttributeInstance)player.func_110148_a(SharedMonsterAttributes.field_111267_a)).func_111130_a(0);
        for (int i = 0; i < 3; ++i) {
            if (toApply != i && collection.contains(health_bonus[i])) {
                player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(health_bonus[i]);
                continue;
            }
            if (toApply != i || collection.contains(health_bonus[i])) continue;
            player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(health_bonus[i]);
        }
        if (updateHealth) {
            if (toApply == -1) {
                player.getEntityData().func_82580_o("health_with_health_bonus");
            } else {
                player.getEntityData().func_74776_a("health_with_health_bonus", player.func_110143_aJ());
            }
            player.func_70606_j(Math.min(currentHealth, player.func_110138_aP()));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack stack;
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        boolean applySpeed = false;
        if (IMC.speed_enchantment_on_boots && (stack = event.player.field_71071_by.func_70440_f(0)) != null) {
            applySpeed = EnchantmentHelper.func_77506_a((int)IMC.enchantment_speed.field_77352_x, (ItemStack)stack) > 0;
        }
        Collection collection = ((ModifiableAttributeInstance)event.player.func_110148_a(SharedMonsterAttributes.field_111263_d)).func_111130_a(0);
        if (!applySpeed && collection.contains(speed_bonus)) {
            event.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(speed_bonus);
        } else if (applySpeed && !collection.contains(speed_bonus)) {
            event.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(speed_bonus);
        }
        TickHandler.updateHealthBonus(event.player, true);
    }

    @SubscribeEvent
    public void onPostWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (!recipesToRemove.isEmpty()) {
                for (int i = 0; i < recipesToRemove.size(); ++i) {
                    CraftingManager.func_77594_a().func_77592_b().remove(recipesToRemove.get(i));
                }
                recipesToRemove.clear();
            }
            if (event.side == Side.SERVER && entitiesToSpawn.containsKey(event.world)) {
                List<Entity> list = entitiesToSpawn.get(event.world);
                for (int i = 0; i < list.size(); ++i) {
                    event.world.func_72838_d(list.get(i));
                }
                entitiesToSpawn.remove(event.world);
            }
        }
    }
}

