/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.material.MapColor;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IStringSerializable;

public enum EnumDyeColor implements IStringSerializable
{
    WHITE(0, 15, "white", "white", MapColor.field_151666_j, EnumChatFormatting.WHITE),
    ORANGE(1, 14, "orange", "orange", MapColor.field_151676_q, EnumChatFormatting.GOLD),
    MAGENTA(2, 13, "magenta", "magenta", MapColor.field_151675_r, EnumChatFormatting.AQUA),
    LIGHT_BLUE(3, 12, "light_blue", "lightBlue", MapColor.field_151674_s, EnumChatFormatting.BLUE),
    YELLOW(4, 11, "yellow", "yellow", MapColor.field_151673_t, EnumChatFormatting.YELLOW),
    LIME(5, 10, "lime", "lime", MapColor.field_151672_u, EnumChatFormatting.GREEN),
    PINK(6, 9, "pink", "pink", MapColor.field_151671_v, EnumChatFormatting.LIGHT_PURPLE),
    GRAY(7, 8, "gray", "gray", MapColor.field_151670_w, EnumChatFormatting.DARK_GRAY),
    SILVER(8, 7, "silver", "silver", MapColor.field_151680_x, EnumChatFormatting.GRAY),
    CYAN(9, 6, "cyan", "cyan", MapColor.field_151679_y, EnumChatFormatting.DARK_AQUA),
    PURPLE(10, 5, "purple", "purple", MapColor.field_151678_z, EnumChatFormatting.DARK_PURPLE),
    BLUE(11, 4, "blue", "blue", MapColor.field_151649_A, EnumChatFormatting.DARK_BLUE),
    BROWN(12, 3, "brown", "brown", MapColor.field_151650_B, EnumChatFormatting.GOLD),
    GREEN(13, 2, "green", "green", MapColor.field_151651_C, EnumChatFormatting.DARK_GREEN),
    RED(14, 1, "red", "red", MapColor.field_151645_D, EnumChatFormatting.DARK_RED),
    BLACK(15, 0, "black", "black", MapColor.field_151646_E, EnumChatFormatting.BLACK);

    private static final EnumDyeColor[] META_LOOKUP;
    private static final EnumDyeColor[] DYE_DMG_LOOKUP;
    private final int meta;
    private final int dyeDamage;
    private final String name;
    private final String unlocalizedName;
    private final MapColor mapColor;
    private final EnumChatFormatting chatColor;

    private EnumDyeColor(int meta, int dyeDamage, String name, String unlocalizedName, MapColor mapColorIn, EnumChatFormatting chatColor) {
        this.meta = meta;
        this.dyeDamage = dyeDamage;
        this.name = name;
        this.unlocalizedName = unlocalizedName;
        this.mapColor = mapColorIn;
        this.chatColor = chatColor;
    }

    public int getMetadata() {
        return this.meta;
    }

    public int getDyeDamage() {
        return this.dyeDamage;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public static EnumDyeColor byDyeDamage(int damage) {
        if (damage < 0 || damage >= DYE_DMG_LOOKUP.length) {
            damage = 0;
        }
        return DYE_DMG_LOOKUP[damage];
    }

    public static EnumDyeColor byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    public String toString() {
        return this.unlocalizedName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        META_LOOKUP = new EnumDyeColor[EnumDyeColor.values().length];
        DYE_DMG_LOOKUP = new EnumDyeColor[EnumDyeColor.values().length];
        EnumDyeColor[] enumDyeColorArray = EnumDyeColor.values();
        int n = enumDyeColorArray.length;
        for (int i = 0; i < n; ++i) {
            EnumDyeColor enumdyecolor;
            EnumDyeColor.META_LOOKUP[enumdyecolor.getMetadata()] = enumdyecolor = enumDyeColorArray[i];
            EnumDyeColor.DYE_DMG_LOOKUP[enumdyecolor.getDyeDamage()] = enumdyecolor;
        }
    }
}

