/*
 * Decompiled with CFR 0.152.
 */
package me.patekcz.capetain.handler;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.patekcz.capetain.Capetain;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;

public class PlayerHandler {
    private static final Map<UUID, PlayerHandler> INSTANCES = new HashMap<UUID, PlayerHandler>();
    private static final String API_URL = "https://raw.githubusercontent.com/patekcz/Capetain/main/api/users.json";
    private static final Map<String, String> PLAYER_CAPES = new HashMap<String, String>();
    private final UUID uuid;
    private final String playerName;
    private class_2960 texture;

    public static void loadCapesFromApi() {
        try {
            URL url = new URL(API_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            try (InputStream is = connection.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                StringBuilder jsonContent = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    jsonContent.append(line);
                }
                Gson gson = new Gson();
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map loadedCapes = (Map)gson.fromJson(jsonContent.toString(), type);
                PLAYER_CAPES.clear();
                PLAYER_CAPES.putAll(loadedCapes);
                Capetain.log("\u00dasp\u011b\u0161n\u011b na\u010dteny cape z API");
            }
        }
        catch (Exception e) {
            Capetain.log("Chyba p\u0159i na\u010d\u00edt\u00e1n\u00ed cape z API: " + e.getMessage());
        }
    }

    public PlayerHandler(UUID uuid) {
        this.uuid = uuid;
        this.playerName = class_310.method_1551().field_1687.method_18470(uuid).method_5477().getString();
        if (PLAYER_CAPES.containsKey(this.playerName)) {
            this.setCape();
        }
    }

    public static PlayerHandler fromPlayer(class_1657 player) {
        PlayerHandler handler = INSTANCES.get(player.method_5667());
        if (handler == null) {
            handler = new PlayerHandler(player.method_5667());
            INSTANCES.put(player.method_5667(), handler);
        }
        return handler;
    }

    public static void onPlayerJoin(class_742 player) {
        PlayerHandler handler = INSTANCES.get(player.method_5667());
        if (handler == null) {
            handler = new PlayerHandler(player.method_5667());
            INSTANCES.put(player.method_5667(), handler);
        } else {
            handler.updateCape();
        }
    }

    public void updateCape() {
        if (PLAYER_CAPES.containsKey(this.playerName)) {
            this.setCape();
        }
    }

    public void setCape() {
        try {
            String capeUrl = PLAYER_CAPES.get(this.playerName);
            URL url = new URL(capeUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            try (InputStream stream = connection.getInputStream();){
                class_1011 image = class_1011.method_4309((InputStream)stream);
                class_310 client = class_310.method_1551();
                client.method_20493(() -> {
                    this.texture = client.method_1531().method_4617(this.uuid.toString().replace("-", ""), new class_1043(this.parseCape(image)));
                });
            }
        }
        catch (IOException ignored) {
            Capetain.log("Nepoda\u0159ilo se na\u010d\u00edst cape pro hr\u00e1\u010de: " + this.playerName);
        }
    }

    private class_1011 parseCape(class_1011 image) {
        int imgHeight;
        int imgWidth = 64;
        int srcWidth = image.method_4307();
        int srcHeight = image.method_4323();
        for (imgHeight = 32; imgWidth < srcWidth || imgHeight < srcHeight; imgWidth *= 2, imgHeight *= 2) {
        }
        class_1011 cape = new class_1011(imgWidth, imgHeight, true);
        for (int x = 0; x < srcWidth; ++x) {
            for (int y = 0; y < srcHeight; ++y) {
                cape.method_4305(x, y, image.method_4315(x, y));
            }
        }
        image.close();
        return cape;
    }

    public class_2960 getTexture(class_742 acpe) {
        if (!PLAYER_CAPES.containsKey(acpe.method_5477().getString())) {
            try {
                try {
                    Method getSkinTextures = class_742.class.getMethod("getSkinTextures", new Class[0]);
                    Object skinTextures = getSkinTextures.invoke((Object)acpe, new Object[0]);
                    Method capeTexture = skinTextures.getClass().getMethod("capeTexture", new Class[0]);
                    return (class_2960)capeTexture.invoke(skinTextures, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    Method getCapeTexture = class_742.class.getMethod("getCapeTexture", new Class[0]);
                    return (class_2960)getCapeTexture.invoke((Object)acpe, new Object[0]);
                }
            }
            catch (Exception e) {
                Capetain.log("Chyba p\u0159i z\u00edsk\u00e1v\u00e1n\u00ed cape textury: " + e.getMessage());
                return null;
            }
        }
        PlayerHandler handler = PlayerHandler.fromPlayer((class_1657)acpe);
        class_2960 tempTexture = handler.getTexture();
        if (tempTexture != null) {
            return tempTexture;
        }
        try {
            try {
                Method getSkinTextures = class_742.class.getMethod("getSkinTextures", new Class[0]);
                Object skinTextures = getSkinTextures.invoke((Object)acpe, new Object[0]);
                Method capeTexture = skinTextures.getClass().getMethod("capeTexture", new Class[0]);
                return (class_2960)capeTexture.invoke(skinTextures, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Method getCapeTexture = class_742.class.getMethod("getCapeTexture", new Class[0]);
                return (class_2960)getCapeTexture.invoke((Object)acpe, new Object[0]);
            }
        }
        catch (Exception e) {
            Capetain.log("Chyba p\u0159i z\u00edsk\u00e1v\u00e1n\u00ed cape textury: " + e.getMessage());
            return null;
        }
    }

    public class_2960 getTexture() {
        return this.texture;
    }
}

