/*
 * Decompiled with CFR 0.152.
 */
package me.patekcz.capetain.handler;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import me.patekcz.capetain.Capetain;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;

public class PlayerHandler {
    private static final Map<UUID, PlayerHandler> INSTANCES = new ConcurrentHashMap<UUID, PlayerHandler>();
    private static final String API_URL = "https://raw.githubusercontent.com/patekcz/Capetain/main/api/users.json";
    private static final Map<String, String> PLAYER_CAPES = new ConcurrentHashMap<String, String>();
    private static final String CAPE_NAMESPACE = "capetain";
    private static final AtomicBoolean isLoadingCapes = new AtomicBoolean(false);
    private final UUID uuid;
    private final String playerName;
    private class_2960 texture;
    private final AtomicBoolean isSettingCape = new AtomicBoolean(false);

    public static void loadCapesFromApi() {
        if (isLoadingCapes.getAndSet(true)) {
            Capetain.log("Ji\u017e prob\u00edh\u00e1 na\u010d\u00edt\u00e1n\u00ed kape z API, p\u0159eskakuji...");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                Capetain.log("Na\u010d\u00edt\u00e1m kape z API: https://raw.githubusercontent.com/patekcz/Capetain/main/api/users.json");
                URL url = new URL(API_URL);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    throw new IOException("HTTP Error: " + responseCode);
                }
                try (InputStream is = connection.getInputStream();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder jsonContent = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        jsonContent.append(line);
                    }
                    Gson gson = new Gson();
                    Type type = new TypeToken<Map<String, String>>(){}.getType();
                    Map loadedCapes = (Map)gson.fromJson(jsonContent.toString(), type);
                    if (loadedCapes == null || loadedCapes.isEmpty()) {
                        Capetain.log("API nevr\u00e1tilo \u017e\u00e1dn\u00e9 kape! Odpov\u011b\u010f: " + jsonContent.toString());
                        return;
                    }
                    PLAYER_CAPES.clear();
                    PLAYER_CAPES.putAll(loadedCapes);
                    Capetain.log("\u00dasp\u011b\u0161n\u011b na\u010dteno " + PLAYER_CAPES.size() + " kape z API");
                    for (PlayerHandler handler : INSTANCES.values()) {
                        if (handler == null) continue;
                        try {
                            handler.updateCape();
                        }
                        catch (Exception e) {
                            Capetain.log("Chyba p\u0159i aktualizaci kape pro hr\u00e1\u010de: " + e.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                Capetain.log("Chyba p\u0159i na\u010d\u00edt\u00e1n\u00ed kape z API: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                isLoadingCapes.set(false);
            }
        });
    }

    public PlayerHandler(UUID uuid) {
        this.uuid = uuid;
        String tempName = "unknown";
        try {
            class_1657 player;
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1687 != null && (player = client.field_1687.method_18470(uuid)) != null) {
                tempName = player.method_5477().getString();
            }
        }
        catch (Exception e) {
            Capetain.log("Chyba p\u0159i z\u00edsk\u00e1v\u00e1n\u00ed jm\u00e9na hr\u00e1\u010de: " + e.getMessage());
        }
        this.playerName = tempName;
        if (!tempName.equals("unknown") && PLAYER_CAPES.containsKey(this.playerName)) {
            this.setCape();
        }
    }

    public static PlayerHandler fromPlayer(class_1657 player) {
        if (player == null) {
            return null;
        }
        UUID playerUuid = player.method_5667();
        if (playerUuid == null) {
            return null;
        }
        try {
            PlayerHandler handler = INSTANCES.get(playerUuid);
            if (handler == null) {
                handler = new PlayerHandler(playerUuid);
                INSTANCES.put(playerUuid, handler);
            }
            return handler;
        }
        catch (Exception e) {
            Capetain.log("Chyba p\u0159i vytv\u00e1\u0159en\u00ed PlayerHandler: " + e.getMessage());
            return null;
        }
    }

    public static void onPlayerJoin(class_742 player) {
        if (player == null) {
            return;
        }
        try {
            UUID playerUuid = player.method_5667();
            if (playerUuid == null) {
                return;
            }
            String playerName = player.method_5477().getString();
            Capetain.debug("Hr\u00e1\u010d p\u0159ipojen: " + playerName + " (UUID: " + String.valueOf(playerUuid) + ")");
            PlayerHandler handler = INSTANCES.get(playerUuid);
            if (handler == null) {
                handler = new PlayerHandler(playerUuid);
                INSTANCES.put(playerUuid, handler);
            } else {
                handler.updateCape();
            }
        }
        catch (Exception e) {
            Capetain.log("Chyba p\u0159i zpracov\u00e1n\u00ed p\u0159ipojen\u00ed hr\u00e1\u010de: " + e.getMessage());
        }
    }

    public void updateCape() {
        try {
            if (PLAYER_CAPES.containsKey(this.playerName)) {
                this.setCape();
            }
        }
        catch (Exception e) {
            Capetain.log("Chyba p\u0159i aktualizaci kape: " + e.getMessage());
        }
    }

    public void setCape() {
        if (this.isSettingCape.getAndSet(true)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String capeUrl = PLAYER_CAPES.get(this.playerName);
                if (capeUrl == null || capeUrl.isEmpty()) {
                    return;
                }
                Capetain.debug("Na\u010d\u00edt\u00e1m kape pro hr\u00e1\u010de " + this.playerName + " z URL: " + capeUrl);
                URL url = new URL(capeUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                try (InputStream stream = connection.getInputStream();){
                    class_1011 image = class_1011.method_4309((InputStream)stream);
                    Capetain.debug("Kape obr\u00e1zek na\u010dten, rozm\u011bry: " + image.method_4307() + "x" + image.method_4323());
                    class_310 client = class_310.method_1551();
                    if (client != null) {
                        class_1011 capeImage = this.parseCape(image);
                        client.execute(() -> {
                            try {
                                if (client.method_1531() != null) {
                                    class_2960 registeredTexture;
                                    class_1043 nativeTexture = new class_1043(capeImage);
                                    this.texture = registeredTexture = client.method_1531().method_4617(this.uuid.toString().replace("-", ""), nativeTexture);
                                    Capetain.debug("Kape textura zaregistrov\u00e1na pro hr\u00e1\u010de " + this.playerName);
                                }
                            }
                            catch (Exception e) {
                                Capetain.log("Chyba p\u0159i registraci textury: " + e.getMessage());
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                Capetain.log("Nepoda\u0159ilo se na\u010d\u00edst kape pro hr\u00e1\u010de: " + this.playerName + " - " + e.getMessage());
            }
            finally {
                this.isSettingCape.set(false);
            }
        });
    }

    private class_1011 parseCape(class_1011 image) {
        try {
            int imgHeight;
            int srcWidth = image.method_4307();
            int srcHeight = image.method_4323();
            int imgWidth = 64;
            for (imgHeight = 32; imgWidth < srcWidth || imgHeight < srcHeight; imgWidth *= 2, imgHeight *= 2) {
            }
            Capetain.debug("P\u0159izp\u016fsobuji rozm\u011bry kape: " + srcWidth + "x" + srcHeight + " -> " + imgWidth + "x" + imgHeight);
            class_1011 cape = new class_1011(imgWidth, imgHeight, true);
            for (int x = 0; x < imgWidth; ++x) {
                for (int y = 0; y < imgHeight; ++y) {
                    cape.method_4305(x, y, 0);
                }
            }
            int offsetX = (imgWidth - srcWidth) / 2;
            int offsetY = (imgHeight - srcHeight) / 2;
            for (int x = 0; x < srcWidth; ++x) {
                for (int y = 0; y < srcHeight; ++y) {
                    int color = image.method_4315(x, y);
                    if ((color >> 24 & 0xFF) <= 0) continue;
                    cape.method_4305(x + offsetX, y + offsetY, color);
                }
            }
            image.close();
            return cape;
        }
        catch (Exception e) {
            Capetain.log("Chyba p\u0159i zpracov\u00e1n\u00ed kape obr\u00e1zku: " + e.getMessage());
            class_1011 fallback = new class_1011(64, 32, true);
            image.close();
            return fallback;
        }
    }

    public class_2960 getTexture(class_742 player) {
        try {
            if (player == null) {
                return null;
            }
            if (this.texture == null) {
                return player.method_3119();
            }
            return this.texture;
        }
        catch (Exception e) {
            Capetain.debug("Chyba p\u0159i z\u00edsk\u00e1v\u00e1n\u00ed textury: " + e.getMessage());
            return player.method_3119();
        }
    }

    public class_2960 getTexture() {
        return this.texture;
    }
}

