/*
 * Decompiled with CFR 0.152.
 */
package net.alexis.adc;

import net.alexis.adc.text.TextAnimation;
import net.alexis.adc.text.TextUtil;
import net.alexis.adc.yacl.YaclConfiguration;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_638;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class DayCounter
implements ClientModInitializer {
    public static final String MOD_ID = "alexis-day-counter";
    public static final String MOD_NAME = "Day Counter";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"alexis-day-counter");
    public static class_304.class_11900 dayCounterCategory;
    public static class_304 openSettingsKey;
    private long lastKnownDay = -1L;
    private TextAnimation currentAnimation = null;
    private boolean specialDayHandled = false;
    private String lastDisplayedText = "";

    public static void initKeyBindings() {
        dayCounterCategory = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"day-counter", (String)"main"));
        openSettingsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.day-counter.open_settings", class_3675.class_307.field_1668, -1, dayCounterCategory));
    }

    public void onInitializeClient() {
        DayCounter.initKeyBindings();
        ClientTickEvents.START_CLIENT_TICK.register(this::onClientTick);
        LOGGER.info(String.format("[%s]: OK!", MOD_NAME));
    }

    public void onClientTick(class_310 client) {
        YaclConfiguration config = YaclConfiguration.getInstance();
        if (openSettingsKey.method_1436() && class_310.method_1551().field_1755 == null) {
            class_310.method_1551().method_1507(YaclConfiguration.createScreen(null));
        }
        if (!config.modEnabled) {
            return;
        }
        if (client.field_1687 == null) {
            this.lastKnownDay = -1L;
            this.currentAnimation = null;
            this.specialDayHandled = false;
            this.lastDisplayedText = "";
            return;
        }
        class_638 world = client.field_1687;
        long currentDay = world.method_8532() / 24000L;
        if (this.lastKnownDay != -1L && this.lastKnownDay != currentDay) {
            this.lastKnownDay = currentDay;
            this.specialDayHandled = false;
            this.lastDisplayedText = "";
            this.currentAnimation = new TextAnimation("Day " + currentDay, 6, 80);
        } else if (this.lastKnownDay == -1L) {
            if (world.method_8532() < 100L) {
                this.currentAnimation = new TextAnimation("Day " + currentDay, 6, 80);
            }
            this.lastKnownDay = currentDay;
        }
        if (this.currentAnimation != null) {
            this.currentAnimation.tick();
            if (this.currentAnimation.hasTextChanged()) {
                String text = this.currentAnimation.getCurrentText();
                if (text.length() > this.lastDisplayedText.length() && client.field_1724 != null && config.textSoundEnabled) {
                    client.field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.3f, 1.5f);
                }
                this.lastDisplayedText = text;
                if (client.field_1724 != null) {
                    class_2561 styledText = TextUtil.getStyledText(text, this.lastKnownDay, this.currentAnimation.isFinished(), false, (class_1937)client.field_1687);
                    client.field_1724.method_7353(styledText, true);
                }
            }
            if (this.currentAnimation.isFinished() && !this.specialDayHandled) {
                this.specialDayHandled = true;
                if (this.lastKnownDay > 0L && this.lastKnownDay % 10000L == 0L) {
                    if (client.field_1724 != null && config.milestone10000Enabled) {
                        if (config.milestone10000SoundEnabled) {
                            client.field_1724.method_5783(class_3417.field_14792, 1.0f, 1.0f);
                        }
                        specialText = "-- Day " + this.lastKnownDay + " --";
                        styledSpecialText = TextUtil.getStyledText(specialText, this.lastKnownDay, true, true, (class_1937)client.field_1687);
                        client.field_1724.method_7353(styledSpecialText, true);
                    }
                } else if (this.lastKnownDay > 0L && this.lastKnownDay % 1000L == 0L) {
                    if (client.field_1724 != null && config.milestone1000Enabled) {
                        if (config.milestone1000SoundEnabled) {
                            client.field_1724.method_5783(class_3417.field_14671, 1.0f, 1.0f);
                        }
                        specialText = "-- Day " + this.lastKnownDay + " --";
                        styledSpecialText = TextUtil.getStyledText(specialText, this.lastKnownDay, true, true, (class_1937)client.field_1687);
                        client.field_1724.method_7353(styledSpecialText, true);
                    }
                } else if (this.lastKnownDay > 0L && this.lastKnownDay % 100L == 0L && client.field_1724 != null && config.milestone100Enabled) {
                    if (config.milestone100SoundEnabled) {
                        client.field_1724.method_5783(class_3417.field_14709, 1.0f, 1.0f);
                    }
                    specialText = "-- Day " + this.lastKnownDay + " --";
                    styledSpecialText = TextUtil.getStyledText(specialText, this.lastKnownDay, true, true, (class_1937)client.field_1687);
                    client.field_1724.method_7353(styledSpecialText, true);
                }
            }
        }
    }
}

