/*
 * Decompiled with CFR 0.152.
 */
package net.alexis.adc.text;

public class TextAnimation {
    private final String fullText;
    private final int ticksPerStep;
    private final int stayTicks;
    private int currentStep = 0;
    private int currentTick = 0;
    private boolean finished = false;
    private String lastText = "";

    public TextAnimation(String fullText, int ticksPerStep, int stayTicks) {
        this.fullText = fullText;
        this.ticksPerStep = ticksPerStep;
        this.stayTicks = stayTicks;
    }

    public void tick() {
        if (this.finished) {
            return;
        }
        ++this.currentTick;
        if (this.currentStep < this.fullText.length()) {
            if (this.currentTick >= this.ticksPerStep) {
                ++this.currentStep;
                this.currentTick = 0;
            }
        } else if (this.currentTick >= this.stayTicks) {
            this.finished = true;
        }
    }

    public String getCurrentText() {
        if (this.currentStep > this.fullText.length()) {
            return this.fullText;
        }
        return this.fullText.substring(0, this.currentStep);
    }

    public boolean hasTextChanged() {
        String current = this.getCurrentText();
        if (!current.equals(this.lastText)) {
            this.lastText = current;
            return true;
        }
        return false;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

