/*
 * Decompiled with CFR 0.152.
 */
package net.alexis.adc.yacl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class YaclConfiguration {
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("alexis_mods/daycounter.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static YaclConfiguration INSTANCE;
    public boolean modEnabled = true;
    public boolean textSoundEnabled = true;
    public boolean milestone100Enabled = true;
    public boolean milestone1000Enabled = true;
    public boolean milestone10000Enabled = true;
    public boolean milestone100SoundEnabled = true;
    public boolean milestone1000SoundEnabled = true;
    public boolean milestone10000SoundEnabled = true;
    public boolean textShadow = true;
    public boolean netherWastesColorEnabled = true;
    public boolean basaltDeltasColorEnabled = true;
    public boolean crimsonForestColorEnabled = true;
    public boolean warpedForestColorEnabled = true;
    public boolean soulSandValleyColorEnabled = true;
    public boolean deepDarkColorEnabled = true;
    public boolean mushroomIslandColorEnabled = true;
    public boolean endColorEnabled = true;

    public static YaclConfiguration getInstance() {
        if (INSTANCE == null) {
            YaclConfiguration.load();
        }
        return INSTANCE;
    }

    public static void load() {
        try {
            if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                String json = Files.readString(CONFIG_FILE);
                INSTANCE = (YaclConfiguration)GSON.fromJson(json, YaclConfiguration.class);
                if (INSTANCE == null) {
                    INSTANCE = new YaclConfiguration();
                }
            } else {
                INSTANCE = new YaclConfiguration();
                YaclConfiguration.save();
            }
        }
        catch (Exception e) {
            INSTANCE = new YaclConfiguration();
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)INSTANCE);
            Files.writeString(CONFIG_FILE, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class_437 createScreen(class_437 parent) {
        YaclConfiguration config = YaclConfiguration.getInstance();
        return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"day-counter.config.title")).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.category.main")).tooltip(new class_2561[]{class_2561.method_43471((String)"day-counter.config.category.main.tooltip")}).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.group.main_settings")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.group.main_settings.description")})).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.mod_enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.mod_enabled.description")})).binding((Object)true, () -> config.modEnabled, newVal -> {
            config.modEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.text_shadow")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.text_shadow.description")})).binding((Object)true, () -> config.textShadow, newVal -> {
            config.textShadow = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).build()).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.group.milestones")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.group.milestones.description")})).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.milestone_100")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.milestone_100.description")})).binding((Object)true, () -> config.milestone100Enabled, newVal -> {
            config.milestone100Enabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.milestone_1000")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.milestone_1000.description")})).binding((Object)true, () -> config.milestone1000Enabled, newVal -> {
            config.milestone1000Enabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.milestone_10000")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.milestone_10000.description")})).binding((Object)true, () -> config.milestone10000Enabled, newVal -> {
            config.milestone10000Enabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.category.sounds")).tooltip(new class_2561[]{class_2561.method_43471((String)"day-counter.config.category.sounds.tooltip")}).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.group.sounds")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.group.sounds.description")})).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.text_sound")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.text_sound.description")})).binding((Object)true, () -> config.textSoundEnabled, newVal -> {
            config.textSoundEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.milestone_100_sound")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.milestone_100_sound.description")})).binding((Object)true, () -> config.milestone100SoundEnabled, newVal -> {
            config.milestone100SoundEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.milestone_1000_sound")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.milestone_1000_sound.description")})).binding((Object)true, () -> config.milestone1000SoundEnabled, newVal -> {
            config.milestone1000SoundEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.milestone_10000_sound")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.milestone_10000_sound.description")})).binding((Object)true, () -> config.milestone10000SoundEnabled, newVal -> {
            config.milestone10000SoundEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.category.colors")).tooltip(new class_2561[]{class_2561.method_43471((String)"day-counter.config.category.colors.tooltip")}).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.group.overworld")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.group.overworld.description")})).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.deep_dark_color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.deep_dark_color.description")})).binding((Object)true, () -> config.deepDarkColorEnabled, newVal -> {
            config.deepDarkColorEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.mushroom_island_color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.mushroom_island_color.description")})).binding((Object)true, () -> config.mushroomIslandColorEnabled, newVal -> {
            config.mushroomIslandColorEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).build()).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.group.nether")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.group.nether.description")})).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.nether_wastes_color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.nether_wastes_color.description")})).binding((Object)true, () -> config.netherWastesColorEnabled, newVal -> {
            config.netherWastesColorEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.basalt_deltas_color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.basalt_deltas_color.description")})).binding((Object)true, () -> config.basaltDeltasColorEnabled, newVal -> {
            config.basaltDeltasColorEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.crimson_forest_color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.crimson_forest_color.description")})).binding((Object)true, () -> config.crimsonForestColorEnabled, newVal -> {
            config.crimsonForestColorEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.warped_forest_color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.warped_forest_color.description")})).binding((Object)true, () -> config.warpedForestColorEnabled, newVal -> {
            config.warpedForestColorEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.soul_sand_valley_color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.soul_sand_valley_color.description")})).binding((Object)true, () -> config.soulSandValleyColorEnabled, newVal -> {
            config.soulSandValleyColorEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).build()).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.group.end")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.group.end.description")})).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"day-counter.config.end_color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"day-counter.config.end_color.description")})).binding((Object)true, () -> config.endColorEnabled, newVal -> {
            config.endColorEnabled = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).build()).build()).save(YaclConfiguration::save).build().generateScreen(parent);
    }
}

