/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.client;

import com.tristankechlo.whatdidijustkill.client.ToastHandler;
import com.tristankechlo.whatdidijustkill.config.types.ToastTheme;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractEntityToast
implements Toast {
    private final Component firstLine;
    private final Component secondLine;
    protected ResourceLocation backgroundTexture = ToastTheme.ADVANCEMENT.getBackgroundTexture();
    protected int displayTime = 2000;
    protected boolean textShadow = true;
    private Toast.Visibility wantedVisibility = Toast.Visibility.HIDE;

    protected AbstractEntityToast(Component firstLine, Component secondLine) {
        this.firstLine = firstLine;
        this.secondLine = secondLine;
    }

    public void update(ToastManager toastManager, long displayTime) {
        if (!ToastHandler.toastsEnabled) {
            this.wantedVisibility = Toast.Visibility.HIDE;
            return;
        }
        this.wantedVisibility = (double)displayTime >= (double)this.displayTime * toastManager.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    public void render(GuiGraphics graphics, Font font, long displayTime) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.backgroundTexture, 0, 0, this.width(), this.height());
        this.renderEntityImage(graphics);
        if (this.secondLine != null) {
            graphics.drawString(font, this.secondLine, 30, 17, -1, this.textShadow);
        }
        int y = this.secondLine == null ? 12 : 7;
        graphics.drawString(font, this.firstLine, 30, y, -1, this.textShadow);
    }

    protected abstract void renderEntityImage(GuiGraphics var1);
}

