/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.client;

import com.tristankechlo.whatdidijustkill.WhatDidIJustKill;
import com.tristankechlo.whatdidijustkill.client.AbstractEntityToast;
import com.tristankechlo.whatdidijustkill.config.WhatDidIJustKillConfig;
import com.tristankechlo.whatdidijustkill.config.types.FormatOption;
import com.tristankechlo.whatdidijustkill.config.types.ToastTheme;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;

public class EntityKilledToast
extends AbstractEntityToast {
    private static final ResourceLocation UNKNOWN_ENTITY = ResourceLocation.fromNamespaceAndPath((String)"whatdidijustkill", (String)"textures/entity_unknown.png");
    private final ResourceLocation entityTexture;

    private EntityKilledToast(Component firstLine, Component secondLine, ResourceLocation entityType) {
        super(firstLine, secondLine);
        this.entityTexture = EntityKilledToast.getTextureLocationSafe(entityType);
        this.displayTime = WhatDidIJustKillConfig.get().entity().timeout();
        this.backgroundTexture = WhatDidIJustKillConfig.get().entity().theme().getBackgroundTexture();
        this.textShadow = WhatDidIJustKillConfig.get().entity().theme() == ToastTheme.ADVANCEMENT;
    }

    @Override
    protected void renderEntityImage(GuiGraphics graphics) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, this.entityTexture, 8, 8, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public static EntityKilledToast make(Component entityName, ResourceLocation entityType, double distance) {
        ToastTheme theme = WhatDidIJustKillConfig.get().entity().theme();
        if (entityName.getStyle().getColor() == null) {
            entityName = entityName.copy().withStyle(theme.getColorHighlight());
        }
        distance = (double)Mth.floor((double)(distance * 10.0)) / 10.0;
        FormatOption firstLineFormat = WhatDidIJustKillConfig.get().entity().firstLine();
        FormatOption secondLineFormat = WhatDidIJustKillConfig.get().entity().secondLine();
        MutableComponent firstLine = firstLineFormat.makeLine(theme, entityName, entityType, distance);
        MutableComponent secondLine = secondLineFormat.makeLine(theme, entityName, entityType, distance);
        return new EntityKilledToast((Component)firstLine, (Component)secondLine, entityType);
    }

    private static ResourceLocation getTextureLocationSafe(ResourceLocation entityType) {
        ResourceLocation expectedLocation = EntityKilledToast.makeExpectedLocation(entityType);
        Optional resource = Minecraft.getInstance().getResourceManager().getResource(expectedLocation);
        if (resource.isEmpty()) {
            WhatDidIJustKill.LOGGER.warn("Did not find icon for '{}' at '{}' using fallback icon.", (Object)entityType, (Object)expectedLocation);
            return UNKNOWN_ENTITY;
        }
        return expectedLocation;
    }

    private static ResourceLocation makeExpectedLocation(ResourceLocation entityType) {
        EntityType type = (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(entityType).orElseThrow()).value();
        String category = type.getCategory().getName().toLowerCase();
        String path = String.format("textures/entity_icon/%s/%s.png", category, entityType.getPath());
        return ResourceLocation.fromNamespaceAndPath((String)entityType.getNamespace(), (String)path);
    }
}

