/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.command;

import com.tristankechlo.whatdidijustkill.WhatDidIJustKill;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class ResponseHelper {
    public static void sendMessageConfigReload(CommandSourceStack source, boolean success) {
        String text = success ? "Config was successfully reloaded." : "Error while reloading config. Check the logs for further details.";
        MutableComponent message = Component.literal((String)text).withStyle(ChatFormatting.WHITE);
        ResponseHelper.sendMessage(source, (Component)message, true);
    }

    public static void sendMessageConfigReset(CommandSourceStack source, boolean success) {
        String text = success ? "Config was successfully reset." : "Error while saving the default config.";
        MutableComponent message = Component.literal((String)text).withStyle(ChatFormatting.WHITE);
        ResponseHelper.sendMessage(source, (Component)message, true);
    }

    public static MutableComponent start() {
        return Component.literal((String)"[WhatDidIJustKill] ").withStyle(ChatFormatting.GOLD);
    }

    public static void sendMessage(CommandSourceStack source, Component message, boolean broadcastToOps) {
        MutableComponent start = ResponseHelper.start().append(message);
        source.sendSuccess(() -> start, broadcastToOps);
    }

    public static MutableComponent clickableLink(String url, String displayText) throws URISyntaxException {
        MutableComponent mutableComponent = Component.literal((String)displayText);
        mutableComponent.withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE});
        URI parsedUrl = new URI(url);
        mutableComponent.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(parsedUrl)));
        return mutableComponent;
    }

    public static MutableComponent clickableLink(String url) {
        try {
            return ResponseHelper.clickableLink(url, url);
        }
        catch (URISyntaxException e) {
            WhatDidIJustKill.LOGGER.error("Failed to create clickable link for URL: {}", (Object)url, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

