/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.config.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.whatdidijustkill.IPlatformHelper;
import com.tristankechlo.whatdidijustkill.config.types.FormatOption;
import com.tristankechlo.whatdidijustkill.config.types.ToastTheme;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public record EntityOptions(ShowToastOption showToast, int timeout, FormatOption firstLine, FormatOption secondLine, ToastTheme theme, List<Either<ResourceLocation, ModWildcard>> excludes) {
    public static final EntityOptions DEFAULT = new EntityOptions(ShowToastOption.NOT_EXCLUDED, 2000, FormatOption.KILLED_DISTANCE, FormatOption.ENTITY_TYPE, ToastTheme.ADVANCEMENT, List.of(Either.left((Object)ResourceLocation.withDefaultNamespace((String)"bat"))));
    public static final Codec<EntityOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ShowToastOption.CODEC.fieldOf("show_toast").forGetter(EntityOptions::showToast), (App)Codec.intRange((int)250, (int)20000).fieldOf("timeout").forGetter(EntityOptions::timeout), (App)FormatOption.CODEC.fieldOf("first_line").forGetter(EntityOptions::firstLine), (App)FormatOption.CODEC.fieldOf("second_line").forGetter(EntityOptions::secondLine), (App)ToastTheme.CODEC.fieldOf("theme").forGetter(EntityOptions::theme), (App)Codec.either((Codec)ResourceLocation.CODEC, ModWildcard.CODEC).listOf().fieldOf("excludes").forGetter(EntityOptions::excludes)).apply((Applicative)instance, EntityOptions::new)).validate(EntityOptions::verify);

    private static DataResult<EntityOptions> verify(EntityOptions options) {
        if (options.firstLine() == FormatOption.NONE) {
            return DataResult.error(() -> "EntityOptions: 'first_line' can not be 'NONE'.");
        }
        return DataResult.success((Object)options);
    }

    public boolean isEntityExcluded(ResourceLocation entityType) {
        for (Either<ResourceLocation, ModWildcard> element : this.excludes()) {
            Optional wildcard = element.right();
            if (wildcard.isPresent() && ((ModWildcard)wildcard.get()).modid().equalsIgnoreCase(entityType.getNamespace())) {
                return true;
            }
            Optional string = element.left();
            if (!string.isPresent() || !((ResourceLocation)string.get()).equals((Object)entityType)) continue;
            return true;
        }
        return false;
    }

    public static enum ShowToastOption implements StringRepresentable
    {
        ALL("ALL"),
        ONLY_NAMED("ONLY_NAMED"),
        NOT_EXCLUDED("NOT_EXCLUDED"),
        NONE("NONE");

        public static final Codec<ShowToastOption> CODEC;
        private final String key;

        private ShowToastOption(String key) {
            this.key = key;
        }

        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ShowToastOption::values);
        }
    }

    public record ModWildcard(String modid) {
        private static final Codec<ModWildcard> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("wildcard").forGetter(ModWildcard::modid)).apply((Applicative)instance, ModWildcard::new)).validate(ModWildcard::verify);

        private static DataResult<ModWildcard> verify(ModWildcard wildcard) {
            if (!IPlatformHelper.INSTANCE.isModLoaded(wildcard.modid())) {
                return DataResult.error(() -> String.format("Not a valid wildcard: \"%s\"", wildcard.modid()));
            }
            return DataResult.success((Object)wildcard);
        }
    }
}

