/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.mixin;

import com.tristankechlo.whatdidijustkill.network.IPacketHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    protected boolean dead;

    @Shadow
    public abstract LivingEntity getKillCredit();

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void onDeath$WhatDidIJustKill(DamageSource source, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (self.isRemoved() || this.dead || self.level().isClientSide()) {
            return;
        }
        Entity causingEntity = source.getEntity();
        Entity directEntity = source.getDirectEntity();
        if (causingEntity == null && directEntity == null) {
            LivingEntity killCredit = this.getKillCredit();
            if (killCredit instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)killCredit;
                IPacketHandler.INSTANCE.sendPacketEntityKilled(player, (Entity)self);
            }
        } else if (causingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)causingEntity;
            IPacketHandler.INSTANCE.sendPacketEntityKilled(player, (Entity)self);
        }
    }
}

