/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.network;

import com.google.auto.service.AutoService;
import com.tristankechlo.whatdidijustkill.network.ClientBoundEntityKilledPacket;
import com.tristankechlo.whatdidijustkill.network.ClientBoundPlayerKilledPacket;
import com.tristankechlo.whatdidijustkill.network.IPacketHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

@AutoService(value={IPacketHandler.class})
public class ForgePacketHandler
implements IPacketHandler {
    private static final SimpleChannel INSTANCE = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"whatdidijustkill", (String)"main")).networkProtocolVersion(1).clientAcceptedVersions((s, i) -> true).serverAcceptedVersions((s, i) -> true).simpleChannel();

    public static void registerPackets() {
        INSTANCE.messageBuilder(ClientBoundEntityKilledPacket.class, 1, NetworkDirection.PLAY_TO_CLIENT).decoder(ClientBoundEntityKilledPacket::decode).encoder((msg, buf) -> ClientBoundEntityKilledPacket.encode(buf, msg)).consumerMainThread(ForgePacketHandler::handleEntityKilled).add();
        INSTANCE.messageBuilder(ClientBoundPlayerKilledPacket.class, 2, NetworkDirection.PLAY_TO_CLIENT).decoder(ClientBoundPlayerKilledPacket::decode).encoder((msg, buf) -> ClientBoundPlayerKilledPacket.encode(buf, msg)).consumerMainThread(ForgePacketHandler::handlePlayerKilled).add();
    }

    @Override
    public void sendPacketEntityKilledByPlayer(ServerPlayer player, ClientBoundEntityKilledPacket packet) {
        INSTANCE.send((Object)packet, PacketDistributor.PLAYER.with((Object)player));
    }

    private static void handleEntityKilled(ClientBoundEntityKilledPacket packet, CustomPayloadEvent.Context context) {
        if (FMLEnvironment.dist.isClient()) {
            ClientBoundEntityKilledPacket.handle(packet);
        }
    }

    @Override
    public void sendPacketPlayerKilledByPlayer(ServerPlayer player, ClientBoundPlayerKilledPacket packet) {
        INSTANCE.send((Object)packet, PacketDistributor.PLAYER.with((Object)player));
    }

    private static void handlePlayerKilled(ClientBoundPlayerKilledPacket packet, CustomPayloadEvent.Context context) {
        if (FMLEnvironment.dist.isClient()) {
            ClientBoundPlayerKilledPacket.handle(packet);
        }
    }
}

