/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.network;

import com.tristankechlo.whatdidijustkill.WhatDidIJustKill;
import com.tristankechlo.whatdidijustkill.network.ClientBoundEntityKilledPacket;
import com.tristankechlo.whatdidijustkill.network.ClientBoundPlayerKilledPacket;
import java.util.UUID;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public interface IPacketHandler {
    public static final IPacketHandler INSTANCE = WhatDidIJustKill.load(IPacketHandler.class);

    public void sendPacketEntityKilledByPlayer(ServerPlayer var1, ClientBoundEntityKilledPacket var2);

    default public void sendPacketEntityKilled(ServerPlayer player, Entity killed) {
        Component entityName = killed.getDisplayName();
        ResourceLocation entityType = BuiltInRegistries.ENTITY_TYPE.getKey((Object)killed.getType());
        double distance = this.calcDistance((Entity)player, killed);
        this.sendPacketEntityKilledByPlayer(player, new ClientBoundEntityKilledPacket(entityName, entityType, distance, killed.hasCustomName()));
    }

    public void sendPacketPlayerKilledByPlayer(ServerPlayer var1, ClientBoundPlayerKilledPacket var2);

    default public void sendPacketPlayerKilled(ServerPlayer player, ServerPlayer deadPlayer) {
        Component playerName = deadPlayer.getDisplayName();
        UUID uuid = deadPlayer.getUUID();
        double distance = this.calcDistance((Entity)player, (Entity)deadPlayer);
        this.sendPacketPlayerKilledByPlayer(player, new ClientBoundPlayerKilledPacket(uuid, playerName, distance));
    }

    default public double calcDistance(Entity entity1, Entity entity2) {
        return Math.sqrt(entity1.blockPosition().distSqr((Vec3i)entity2.blockPosition()));
    }
}

