/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.client;

import com.tristankechlo.whatdidijustkill.WhatDidIJustKill;
import com.tristankechlo.whatdidijustkill.client.AbstractEntityToast;
import com.tristankechlo.whatdidijustkill.config.WhatDidIJustKillConfig;
import com.tristankechlo.whatdidijustkill.config.types.FormatOption;
import com.tristankechlo.whatdidijustkill.config.types.ToastTheme;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class EntityKilledToast
extends AbstractEntityToast {
    private static final class_2960 UNKNOWN_ENTITY = class_2960.method_60655((String)"whatdidijustkill", (String)"textures/entity_unknown.png");
    private final class_2960 entityTexture;

    private EntityKilledToast(class_2561 firstLine, class_2561 secondLine, class_2960 entityType) {
        super(firstLine, secondLine);
        this.entityTexture = EntityKilledToast.getTextureLocationSafe(entityType);
        this.displayTime = WhatDidIJustKillConfig.get().entity().timeout();
        this.backgroundTexture = WhatDidIJustKillConfig.get().entity().theme().getBackgroundTexture();
        this.textShadow = WhatDidIJustKillConfig.get().entity().theme() == ToastTheme.ADVANCEMENT;
    }

    @Override
    protected void renderEntityImage(class_332 graphics) {
        graphics.method_25290(class_10799.field_56883, this.entityTexture, 8, 8, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public static EntityKilledToast make(class_2561 entityName, class_2960 entityType, double distance) {
        ToastTheme theme = WhatDidIJustKillConfig.get().entity().theme();
        if (entityName.method_10866().method_10973() == null) {
            entityName = entityName.method_27661().method_27692(theme.getColorHighlight());
        }
        distance = (double)class_3532.method_15357((double)(distance * 10.0)) / 10.0;
        FormatOption firstLineFormat = WhatDidIJustKillConfig.get().entity().firstLine();
        FormatOption secondLineFormat = WhatDidIJustKillConfig.get().entity().secondLine();
        class_5250 firstLine = firstLineFormat.makeLine(theme, entityName, entityType, distance);
        class_5250 secondLine = secondLineFormat.makeLine(theme, entityName, entityType, distance);
        return new EntityKilledToast((class_2561)firstLine, (class_2561)secondLine, entityType);
    }

    private static class_2960 getTextureLocationSafe(class_2960 entityType) {
        class_2960 expectedLocation = EntityKilledToast.makeExpectedLocation(entityType);
        Optional resource = class_310.method_1551().method_1478().method_14486(expectedLocation);
        if (resource.isEmpty()) {
            WhatDidIJustKill.LOGGER.warn("Did not find icon for '{}' at '{}' using fallback icon.", (Object)entityType, (Object)expectedLocation);
            return UNKNOWN_ENTITY;
        }
        return expectedLocation;
    }

    private static class_2960 makeExpectedLocation(class_2960 entityType) {
        class_1299 type = (class_1299)((class_6880.class_6883)class_7923.field_41177.method_10223(entityType).orElseThrow()).comp_349();
        String category = type.method_5891().method_6133().toLowerCase();
        String path = String.format("textures/entity_icon/%s/%s.png", category, entityType.method_12832());
        return class_2960.method_60655((String)entityType.method_12836(), (String)path);
    }
}

