/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.client;

import com.tristankechlo.whatdidijustkill.client.AbstractEntityToast;
import com.tristankechlo.whatdidijustkill.config.WhatDidIJustKillConfig;
import com.tristankechlo.whatdidijustkill.config.types.FormatOption;
import com.tristankechlo.whatdidijustkill.config.types.ToastTheme;
import java.util.UUID;
import net.minecraft.class_10799;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_7923;

public class PlayerKilledToast
extends AbstractEntityToast {
    private static final class_2960 UNKNOWN_PLAYER = class_2960.method_60655((String)"whatdidijustkill", (String)"textures/player.png");
    private final class_2960 playerTexture;

    private PlayerKilledToast(class_2561 firstLine, class_2561 secondLine, class_2960 texture) {
        super(firstLine, secondLine);
        this.playerTexture = texture;
        this.displayTime = WhatDidIJustKillConfig.get().player().timeout();
        this.backgroundTexture = WhatDidIJustKillConfig.get().player().theme().getBackgroundTexture();
        this.textShadow = WhatDidIJustKillConfig.get().player().theme() == ToastTheme.ADVANCEMENT;
    }

    @Override
    protected void renderEntityImage(class_332 graphics) {
        if (this.playerTexture == UNKNOWN_PLAYER) {
            graphics.method_25290(class_10799.field_56883, this.playerTexture, 8, 8, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            graphics.method_51448().pushMatrix();
            graphics.method_51448().scale(2.0f, 2.0f);
            graphics.method_25290(class_10799.field_56883, this.playerTexture, 4, 4, 8.0f, 8.0f, 8, 8, 64, 64);
            graphics.method_51448().popMatrix();
        }
    }

    public static PlayerKilledToast make(UUID uuid, class_2561 entityName, double distance) {
        ToastTheme theme = WhatDidIJustKillConfig.get().player().theme();
        if (entityName.method_10866().method_10973() == null) {
            entityName = entityName.method_27661().method_27692(theme.getColorHighlight());
        }
        distance = (double)class_3532.method_15357((double)(distance * 10.0)) / 10.0;
        class_2960 entityType = class_7923.field_41177.method_10221((Object)class_1299.field_6097);
        class_2960 texture = PlayerKilledToast.getTextureLocation(uuid);
        FormatOption firstLineFormat = WhatDidIJustKillConfig.get().player().firstLine();
        FormatOption secondLineFormat = WhatDidIJustKillConfig.get().player().secondLine();
        class_5250 firstLine = firstLineFormat.makeLine(theme, entityName, entityType, distance);
        class_5250 secondLine = secondLineFormat.makeLine(theme, entityName, entityType, distance);
        return new PlayerKilledToast((class_2561)firstLine, (class_2561)secondLine, texture);
    }

    private static class_2960 getTextureLocation(UUID uuid) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return UNKNOWN_PLAYER;
        }
        class_1657 player = level.method_18470(uuid);
        if (player instanceof class_742) {
            class_742 p = (class_742)player;
            return p.method_52814().comp_1626().comp_3627();
        }
        return UNKNOWN_PLAYER;
    }
}

