/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.client;

import com.tristankechlo.whatdidijustkill.client.AbstractEntityToast;
import com.tristankechlo.whatdidijustkill.config.WhatDidIJustKillConfig;
import com.tristankechlo.whatdidijustkill.config.types.FormatOption;
import com.tristankechlo.whatdidijustkill.config.types.ToastTheme;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class PlayerKilledToast
extends AbstractEntityToast {
    private static final ResourceLocation UNKNOWN_PLAYER = ResourceLocation.fromNamespaceAndPath((String)"whatdidijustkill", (String)"textures/player.png");
    private final ResourceLocation playerTexture;

    private PlayerKilledToast(Component firstLine, Component secondLine, ResourceLocation texture) {
        super(firstLine, secondLine);
        this.playerTexture = texture;
        this.displayTime = WhatDidIJustKillConfig.get().player().timeout();
        this.backgroundTexture = WhatDidIJustKillConfig.get().player().theme().getBackgroundTexture();
        this.textShadow = WhatDidIJustKillConfig.get().player().theme() == ToastTheme.ADVANCEMENT;
    }

    @Override
    protected void renderEntityImage(GuiGraphics graphics) {
        if (this.playerTexture == UNKNOWN_PLAYER) {
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.playerTexture, 8, 8, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            graphics.pose().pushMatrix();
            graphics.pose().scale(2.0f, 2.0f);
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.playerTexture, 4, 4, 8.0f, 8.0f, 8, 8, 64, 64);
            graphics.pose().popMatrix();
        }
    }

    public static PlayerKilledToast make(UUID uuid, Component entityName, double distance) {
        ToastTheme theme = WhatDidIJustKillConfig.get().player().theme();
        if (entityName.getStyle().getColor() == null) {
            entityName = entityName.copy().withStyle(theme.getColorHighlight());
        }
        distance = (double)Mth.floor((double)(distance * 10.0)) / 10.0;
        ResourceLocation entityType = BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.PLAYER);
        ResourceLocation texture = PlayerKilledToast.getTextureLocation(uuid);
        FormatOption firstLineFormat = WhatDidIJustKillConfig.get().player().firstLine();
        FormatOption secondLineFormat = WhatDidIJustKillConfig.get().player().secondLine();
        MutableComponent firstLine = firstLineFormat.makeLine(theme, entityName, entityType, distance);
        MutableComponent secondLine = secondLineFormat.makeLine(theme, entityName, entityType, distance);
        return new PlayerKilledToast((Component)firstLine, (Component)secondLine, texture);
    }

    private static ResourceLocation getTextureLocation(UUID uuid) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return UNKNOWN_PLAYER;
        }
        Player player = level.getPlayerByUUID(uuid);
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer p = (AbstractClientPlayer)player;
            return p.getSkin().body().texturePath();
        }
        return UNKNOWN_PLAYER;
    }
}

