/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.config.types;

import com.mojang.serialization.Codec;
import com.tristankechlo.whatdidijustkill.config.types.ToastTheme;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public enum FormatOption implements StringRepresentable
{
    KILLED("KILLED", (theme, entityName, entityType, distance) -> Component.translatable((String)"screen.whatdidijustkill.killed", (Object[])new Object[]{entityName}).withStyle(theme.getColorText())),
    KILLED_DISTANCE("KILLED_DISTANCE", (theme, entityName, entityType, distance) -> Component.translatable((String)"screen.whatdidijustkill.killed.distance", (Object[])new Object[]{entityName, distance}).withStyle(theme.getColorText())),
    DISTANCE("DISTANCE", (theme, entityName, entityType, distance) -> Component.translatable((String)"screen.whatdidijustkill.distance", (Object[])new Object[]{distance}).withStyle(theme.getColorText())),
    ENTITY_TYPE("ENTITY_TYPE", (theme, entityName, entityType, distance) -> Component.literal((String)entityType.toString()).withStyle(theme.getColorEntityType())),
    NONE("NONE", (theme, entityName, entityType, distance) -> null);

    public static final Codec<FormatOption> CODEC;
    private final LineFormatter formatter;
    private final String key;

    private FormatOption(String key, LineFormatter formatter) {
        this.key = key;
        this.formatter = formatter;
    }

    public MutableComponent makeLine(ToastTheme theme, Component entityName, ResourceLocation entityType, double distance) {
        return this.formatter.format(theme, entityName, entityType, distance);
    }

    public String getSerializedName() {
        return this.key;
    }

    static {
        CODEC = StringRepresentable.fromEnum(FormatOption::values);
    }

    @FunctionalInterface
    private static interface LineFormatter {
        public MutableComponent format(ToastTheme var1, Component var2, ResourceLocation var3, double var4);
    }
}

