/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.network;

import com.tristankechlo.whatdidijustkill.WhatDidIJustKill;
import com.tristankechlo.whatdidijustkill.client.ToastHandler;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record ClientBoundPlayerKilledPacket(UUID uuid, Component playerName, double distance) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientBoundPlayerKilledPacket> TYPE = new CustomPacketPayload.Type(WhatDidIJustKill.PLAYER_KILLED);
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientBoundPlayerKilledPacket> CODEC = StreamCodec.of(ClientBoundPlayerKilledPacket::encode, ClientBoundPlayerKilledPacket::decode);

    public static void encode(RegistryFriendlyByteBuf buffer, ClientBoundPlayerKilledPacket packet) {
        buffer.writeUUID(packet.uuid());
        ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)packet.playerName());
        buffer.writeDouble(packet.distance());
    }

    public static ClientBoundPlayerKilledPacket decode(RegistryFriendlyByteBuf buffer) {
        UUID uuid = buffer.readUUID();
        Component entityName = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer);
        double distance = buffer.readDouble();
        return new ClientBoundPlayerKilledPacket(uuid, entityName, distance);
    }

    public static void handle(ClientBoundPlayerKilledPacket packet) {
        ToastHandler.showToastPlayer(packet.uuid, packet.playerName, packet.distance);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

