/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockEntity.custom;

import com.besson.endfield.blockEntity.ModBlockEntities;
import com.besson.endfield.recipe.custom.OreRigRecipe;
import com.besson.endfield.screen.custom.PortableOriginiumRigScreenHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PortableOriginiumRigBlockEntity
extends BlockEntity
implements GeoBlockEntity,
MenuProvider {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isWorking;
    private static final int OUTPUT_SLOT = 0;
    protected final ContainerData propertyDelegate;
    private int progress = 0;
    private int maxProgress = 40;
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PortableOriginiumRigBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<ItemStackHandler> lazyOptional = LazyOptional.of(() -> this.itemStackHandler);

    public PortableOriginiumRigBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PORTABLE_ORIGINIUM_RIG.get(), pos, state);
        this.propertyDelegate = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> PortableOriginiumRigBlockEntity.this.progress;
                    case 1 -> PortableOriginiumRigBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        PortableOriginiumRigBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        PortableOriginiumRigBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.lazyOptional = LazyOptional.of(() -> this.itemStackHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyOptional.invalidate();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> this.isWorking ? state.setAndContinue(RawAnimation.begin().thenLoop("working")) : state.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.itemStackHandler.serializeNBT());
        pTag.m_128405_("portable_originium_rig.progress", this.progress);
        pTag.m_128379_("portable_originium_rig.isWorking", this.isWorking);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemStackHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("portable_originium_rig.progress");
        this.isWorking = pTag.m_128471_("portable_originium_rig.isWorking");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"blockEntity.portable_originium_rig");
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public void tick(Level world, BlockPos pos, BlockState state, PortableOriginiumRigBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        boolean activeNow = this.hasCorrectRecipe(world);
        if (this.isOutputSlotAvailable()) {
            if (activeNow) {
                this.incrementProgress();
                PortableOriginiumRigBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
                if (this.hasCraftFinished()) {
                    this.craftItem(world);
                    this.resetProgress();
                }
            } else {
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            PortableOriginiumRigBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
        if (entity.isWorking != activeNow) {
            entity.isWorking = activeNow;
            entity.m_6596_();
            world.m_7260_(pos, state, state, 3);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem(Level world) {
        Optional<OreRigRecipe> match = this.getMatchRecipe(world);
        if (match.isPresent()) {
            ItemStack result = match.get().m_8043_(world.m_9598_());
            ItemStack outputStack = this.itemStackHandler.getStackInSlot(0);
            this.itemStackHandler.setStackInSlot(0, new ItemStack((ItemLike)result.m_41720_(), outputStack.m_41613_() + result.m_41613_()));
        }
    }

    private Optional<OreRigRecipe> getMatchRecipe(Level world) {
        SimpleContainer inv = new SimpleContainer(1);
        BlockState belowState = world.m_8055_(this.m_58899_().m_7495_());
        ItemStack belowStack = belowState.m_60734_().m_5456_().m_7968_();
        inv.m_6836_(0, belowStack);
        return world.m_7465_().m_44015_((RecipeType)OreRigRecipe.Type.INSTANCE, (Container)inv, world).map(recipe -> recipe);
    }

    private boolean hasCraftFinished() {
        return this.progress >= this.maxProgress;
    }

    private void incrementProgress() {
        ++this.progress;
    }

    private boolean hasCorrectRecipe(Level world) {
        Optional<OreRigRecipe> match = this.getMatchRecipe(world);
        if (match.isPresent()) {
            ItemStack result = match.get().m_8043_(world.m_9598_());
            return this.canInsertItem(result);
        }
        return false;
    }

    private boolean canInsertItem(ItemStack item) {
        ItemStack outputStack = this.itemStackHandler.getStackInSlot(0);
        return outputStack.m_41619_() || outputStack.m_41720_() == item.m_41720_() && outputStack.m_41613_() + item.m_41613_() <= outputStack.m_41741_();
    }

    private boolean isOutputSlotAvailable() {
        ItemStack outputStack = this.itemStackHandler.getStackInSlot(0);
        return outputStack.m_41619_() || outputStack.m_41613_() < outputStack.m_41741_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PortableOriginiumRigScreenHandler(pContainerId, pPlayerInventory, this, this.propertyDelegate);
    }

    public ContainerData getPropertyDelegate() {
        return this.propertyDelegate;
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        for (int i = 0; i < items.size(); ++i) {
            items.set(i, (Object)this.itemStackHandler.getStackInSlot(i));
        }
        return items;
    }
}

