/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockEntity.custom;

import com.besson.endfield.blockEntity.ModBlockEntities;
import com.besson.endfield.blockEntity.custom.ThermalBankBlockEntity;
import com.besson.endfield.screen.custom.ProtocolAnchorCoreScreenHandler;
import com.besson.endfield.util.ProtocolAnchorCoreStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ProtocolAnchorCoreBlockEntity
extends BlockEntity
implements GeoBlockEntity,
MenuProvider {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int buffer = 0;
    private final int baseMaxBuffer = 100000;
    private final int basePower = 150;
    private int extraPower = 0;
    private int loadNode = 0;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ProtocolAnchorCoreBlockEntity.this.buffer;
                case 1 -> ProtocolAnchorCoreBlockEntity.this.getMaxBuffer();
                case 2 -> ProtocolAnchorCoreBlockEntity.this.basePower;
                case 3 -> ProtocolAnchorCoreBlockEntity.this.getExtraPower();
                case 4 -> ProtocolAnchorCoreBlockEntity.this.loadNode;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
        }

        public int m_6499_() {
            return 5;
        }
    };

    public ProtocolAnchorCoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PROTOCOL_ANCHOR_CORE.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ProtocolAnchorCoreBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        entity.buffer = Math.min(entity.buffer + entity.getTotalPower(), entity.getMaxBuffer());
        entity.m_6596_();
    }

    private int getNearbyThermalBankPower() {
        int sum = 0;
        int loadNode = 0;
        BlockPos blockPos = this.m_58899_();
        if (this.f_58857_ != null) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-30, -10, -30), (BlockPos)blockPos.m_7918_(30, 10, 30))) {
                BlockEntity be = this.f_58857_.m_7702_(pos);
                if (!(be instanceof ThermalBankBlockEntity)) continue;
                ThermalBankBlockEntity blockEntity = (ThermalBankBlockEntity)be;
                sum += blockEntity.getPowerOutput();
                ++loadNode;
            }
        }
        this.loadNode = loadNode;
        return sum;
    }

    public int getMaxBuffer() {
        return 100000 + this.getNearbyThermalBankPower();
    }

    private int getExtraPower() {
        this.extraPower = this.getNearbyThermalBankPower();
        return this.extraPower;
    }

    public int getTotalPower() {
        return 150 + this.getExtraPower();
    }

    public ProtocolAnchorCoreStatus getStatus() {
        return new ProtocolAnchorCoreStatus(this.buffer, this.getMaxBuffer(), 150, this.getExtraPower(), this.loadNode);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> state.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"blockEntity.protocol_anchor_core");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ProtocolAnchorCoreScreenHandler(pContainerId, pPlayerInventory, this, this.propertyDelegate);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("buffer", this.buffer);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.buffer = pTag.m_128451_("buffer");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public int getStoredPower() {
        return this.buffer;
    }

    public boolean canSupplyPower() {
        return this.buffer >= 100;
    }

    public void consumePower(int i) {
        this.buffer = Math.max(0, this.buffer - i);
        this.m_6596_();
    }
}

