/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockEntity.custom;

import com.besson.endfield.block.ElectrifiableDevice;
import com.besson.endfield.block.custom.GearingUnitBlock;
import com.besson.endfield.blockEntity.ModBlockEntities;
import com.besson.endfield.recipe.InputEntry;
import com.besson.endfield.recipe.custom.GearingUnitRecipe;
import com.besson.endfield.screen.custom.GearingUnitScreenHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GearingUnitBlockEntity
extends BlockEntity
implements GeoBlockEntity,
MenuProvider,
ElectrifiableDevice {
    public static final int INPUT_SLOT1 = 0;
    public static final int INPUT_SLOT2 = 1;
    public static final int OUTPUT_SLOT = 2;
    protected final ContainerData propertyDelegate;
    private int progress = 0;
    private int maxProgress = 200;
    private int storePower = 0;
    private static final int POWER_PRE_TICK = 10;
    private boolean isWorking = false;
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            GearingUnitBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> input = LazyOptional.empty();
    private LazyOptional<IItemHandler> output = LazyOptional.empty();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GearingUnitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.GEARING_UNIT.get(), pos, state);
        this.propertyDelegate = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> GearingUnitBlockEntity.this.progress;
                    case 1 -> GearingUnitBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        GearingUnitBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        GearingUnitBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return LazyOptional.of(() -> this.itemStackHandler).cast();
            }
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)GearingUnitBlock.FACING);
            if (side == facing) {
                if (!this.input.isPresent()) {
                    this.input = LazyOptional.of(() -> new InputItemHandler(this.itemStackHandler));
                }
                return this.input.cast();
            }
            if (side == facing.m_122424_()) {
                if (!this.output.isPresent()) {
                    this.output = LazyOptional.of(() -> new OutputItemHandler(this.itemStackHandler));
                }
                return this.output.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.input.invalidate();
        this.output.invalidate();
    }

    public void onLoad() {
        super.onLoad();
        this.input = LazyOptional.of(() -> new InputItemHandler(this.itemStackHandler));
        this.output = LazyOptional.of(() -> new OutputItemHandler(this.itemStackHandler));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.m_122780_((int)this.itemStackHandler.getSlots(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemStackHandler.getStackInSlot(i));
        }
        return items;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"blockEntity.gearing_unit");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new GearingUnitScreenHandler(pContainerId, pPlayerInventory, this, this.propertyDelegate);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.itemStackHandler.serializeNBT());
        pTag.m_128405_("progress", this.progress);
        pTag.m_128379_("isWorking", this.isWorking);
        pTag.m_128405_("storePower", this.storePower);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemStackHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("progress");
        this.isWorking = pTag.m_128471_("isWorking");
        this.storePower = pTag.m_128451_("storePower");
    }

    public static void tick(Level world, BlockPos pos, BlockState state, GearingUnitBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        if (entity.isOutputSlotAvailable()) {
            boolean hasRecipe = entity.hasCorrectRecipe(world);
            if (entity.needsPower() || !hasRecipe) {
                entity.isWorking = false;
            } else if (!entity.needsPower() && !entity.isWorking) {
                entity.isWorking = true;
            }
            entity.m_6596_();
            world.m_7260_(pos, state, state, 3);
            if (hasRecipe && entity.storePower >= 10) {
                entity.storePower -= 10;
                entity.incrementProgress();
                entity.m_6596_();
                if (entity.hasCraftingFinished()) {
                    entity.craftItem(world);
                    entity.resetProgress();
                    entity.m_6596_();
                }
            } else {
                entity.resetProgress();
                entity.m_6596_();
            }
        } else {
            entity.resetProgress();
            entity.m_6596_();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private Optional<GearingUnitRecipe> getMatchRecipe(Level world) {
        SimpleContainer inv = new SimpleContainer(3);
        for (int i = 0; i < 3; ++i) {
            inv.m_6836_(i, this.itemStackHandler.getStackInSlot(i));
        }
        return world.m_7465_().m_44015_((RecipeType)GearingUnitRecipe.Type.INSTANCE, (Container)inv, world);
    }

    private void craftItem(Level world) {
        Optional<GearingUnitRecipe> match = this.getMatchRecipe(world);
        if (match.isPresent()) {
            ItemStack result = match.get().m_8043_(world.m_9598_());
            this.itemStackHandler.setStackInSlot(2, new ItemStack((ItemLike)result.m_41720_(), this.itemStackHandler.getStackInSlot(2).m_41613_() + result.m_41613_()));
            NonNullList<InputEntry> recipeInputs = match.get().getInput();
            boolean[] used = new boolean[2];
            block0: for (InputEntry entry : recipeInputs) {
                for (int i = 0; i < used.length; ++i) {
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    if (used[i] || !entry.getIngredient().test(stack) || stack.m_41613_() < entry.getCount()) continue;
                    this.itemStackHandler.extractItem(i, entry.getCount(), false);
                    used[i] = true;
                    continue block0;
                }
            }
        }
    }

    private boolean hasCorrectRecipe(Level world) {
        Optional<GearingUnitRecipe> match = this.getMatchRecipe(world);
        if (match.isPresent()) {
            NonNullList<InputEntry> recipeInputs = match.get().getInput();
            boolean[] used = new boolean[recipeInputs.size()];
            for (InputEntry entry : recipeInputs) {
                boolean matched = false;
                for (int i = 0; i < used.length; ++i) {
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    if (used[i] || !entry.getIngredient().test(stack) || stack.m_41613_() < entry.getCount()) continue;
                    used[i] = true;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return false;
            }
            ItemStack result = match.get().m_8043_(world.m_9598_());
            return this.canInsertItem(result);
        }
        return false;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void incrementProgress() {
        ++this.progress;
    }

    private boolean canInsertItem(ItemStack item) {
        ItemStack outputStack = this.itemStackHandler.getStackInSlot(2);
        return outputStack.m_41619_() || outputStack.m_41720_() == item.m_41720_() && outputStack.m_41613_() + item.m_41613_() <= outputStack.m_41741_();
    }

    private boolean isOutputSlotAvailable() {
        ItemStack outputStack = this.itemStackHandler.getStackInSlot(2);
        return outputStack.m_41619_() || outputStack.m_41613_() < outputStack.m_41741_();
    }

    @Override
    public void receiveElectricCharge(int amount) {
        this.storePower += amount;
        if (this.storePower > 100) {
            this.storePower = 100;
        }
    }

    @Override
    public boolean needsPower() {
        return this.storePower < 10;
    }

    @Override
    public int getRequiredPower() {
        return 10;
    }

    private static class OutputItemHandler
    implements IItemHandler {
        private final ItemStackHandler parent;

        public OutputItemHandler(ItemStackHandler parent) {
            this.parent = parent;
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.parent.getStackInSlot(2);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.parent.extractItem(2, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }

    private static class InputItemHandler
    implements IItemHandler {
        private final ItemStackHandler parent;

        public InputItemHandler(ItemStackHandler parent) {
            this.parent = parent;
        }

        public int getSlots() {
            return 2;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return this.parent.getStackInSlot(0);
            }
            if (slot == 1) {
                return this.parent.getStackInSlot(1);
            }
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == 0) {
                return this.parent.insertItem(0, stack, simulate);
            }
            if (slot == 1) {
                return this.parent.insertItem(1, stack, simulate);
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }
    }
}

