/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockentity.custom;

import com.besson.endfield.block.ElectrifiableDevice;
import com.besson.endfield.blockentity.ModBlockEntities;
import com.besson.endfield.blockentity.custom.ProtocolAnchorCoreBlockEntity;
import com.besson.endfield.blockentity.custom.RelayTowerBlockEntity;
import com.besson.endfield.power.PowerNetworkManager;
import java.util.ArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ElectricPylonBlockEntity
extends class_2586
implements GeoBlockEntity {
    private class_2338 connectedNode;
    private boolean registeredToManager = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ElectricPylonBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.ELECTRIC_PYLON, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ElectricPylonBlockEntity entity) {
        if (world.method_8608()) {
            return;
        }
        if (entity.connectedNode == null || world.method_8321(entity.connectedNode) == null) {
            class_2338 closest = null;
            double closestDist = Double.MAX_VALUE;
            for (class_2338 p : class_2338.method_10097((class_2338)pos.method_10069(-30, -30, -30), (class_2338)pos.method_10069(30, 30, 30))) {
                double d;
                class_2586 candidate;
                if (p.equals((Object)pos) || !((candidate = world.method_8321(p)) instanceof ProtocolAnchorCoreBlockEntity) && !(candidate instanceof RelayTowerBlockEntity) || !((d = pos.method_10262((class_2382)p)) < closestDist)) continue;
                closest = p.method_10062();
                closestDist = d;
            }
            entity.connectedNode = closest;
            ElectricPylonBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            world.method_8413(pos, state, state, 3);
        }
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        if (!this.registeredToManager && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            PowerNetworkManager.get(serverWorld).registerConsumer(this.method_11016(), () -> {
                try {
                    return this.getSurroundingDemand();
                }
                catch (Throwable t) {
                    return 0;
                }
            }, amount -> {
                try {
                    this.distributeToSurroundings((Integer)amount);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.registeredToManager = true;
        }
    }

    private void distributeToSurroundings(Integer amount) {
        if (this.field_11863 == null || amount <= 0) {
            return;
        }
        ArrayList<ElectrifiableDevice> devices = new ArrayList<ElectrifiableDevice>();
        for (class_2338 target : class_2338.method_10097((class_2338)this.field_11867.method_10069(-10, -10, -10), (class_2338)this.field_11867.method_10069(10, 10, 10))) {
            ElectrifiableDevice device;
            class_2586 be = this.field_11863.method_8321(target);
            if (!(be instanceof ElectrifiableDevice) || !(device = (ElectrifiableDevice)be).needsPower()) continue;
            devices.add(device);
        }
        if (devices.isEmpty()) {
            return;
        }
        devices.sort((a, b) -> Integer.compare(b.getRequiredPower(), a.getRequiredPower()));
        for (ElectrifiableDevice device : devices) {
            if (amount <= 0) break;
            int required = device.getRequiredPower();
            int toGive = Math.min(required, amount);
            device.receiveElectricCharge(toGive);
            amount = amount - toGive;
        }
    }

    private Integer getSurroundingDemand() {
        if (this.field_11863 == null) {
            return 0;
        }
        int totalDemand = 0;
        for (class_2338 target : class_2338.method_10097((class_2338)this.field_11867.method_10069(-10, -10, -10), (class_2338)this.field_11867.method_10069(10, 10, 10))) {
            ElectrifiableDevice device;
            class_2586 be = this.field_11863.method_8321(target);
            if (!(be instanceof ElectrifiableDevice) || !(device = (ElectrifiableDevice)be).needsPower()) continue;
            totalDemand += device.getRequiredPower();
        }
        return totalDemand;
    }

    public void method_11012() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            PowerNetworkManager.get(serverWorld).unregisterConsumer(this.method_11016());
        }
        super.method_11012();
    }

    public class_2338 getConnectedNode() {
        return this.connectedNode;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.connectedNode != null) {
            nbt.method_10569("connectedX", this.connectedNode.method_10263());
            nbt.method_10569("connectedY", this.connectedNode.method_10264());
            nbt.method_10569("connectedZ", this.connectedNode.method_10260());
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("connectedX") && nbt.method_10545("connectedY") && nbt.method_10545("connectedZ")) {
            int x = nbt.method_10550("connectedX");
            int y = nbt.method_10550("connectedY");
            int z = nbt.method_10550("connectedZ");
            this.connectedNode = new class_2338(x, y, z);
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> state.setAndContinue(RawAnimation.begin().thenLoop("working")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

