/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockentity.custom;

import com.besson.endfield.block.custom.ProtocolAnchorCoreBlock;
import com.besson.endfield.blockentity.ImplementedInventory;
import com.besson.endfield.blockentity.ModBlockEntities;
import com.besson.endfield.blockentity.custom.ThermalBankBlockEntity;
import com.besson.endfield.power.PowerNetworkManager;
import com.besson.endfield.screen.custom.ProtocolAnchorCoreScreenHandler;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ProtocolAnchorCoreBlockEntity
extends class_2586
implements GeoBlockEntity,
ExtendedScreenHandlerFactory,
ImplementedInventory,
class_1278 {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final class_2371<class_1799> inv = class_2371.method_10213((int)54, (Object)class_1799.field_8037);
    public int buffer = 0;
    private int cachedNearbyPower = 0;
    private boolean registeredToManager = false;

    public ProtocolAnchorCoreBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.PROTOCOL_ANCHOR_CORE, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inv;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ProtocolAnchorCoreBlockEntity entity) {
        if (world.method_8608()) {
            return;
        }
        int totalPower = entity.getTotalPower();
        int newBuffer = Math.min(entity.buffer + totalPower, entity.getMaxBuffer());
        if (newBuffer != entity.buffer) {
            entity.buffer = newBuffer;
            entity.method_5431();
        }
    }

    private int getNearbyThermalBankPower() {
        int sum = 0;
        class_2338 blockPos = this.method_11016();
        if (this.field_11863 != null) {
            for (class_2338 pos : class_2338.method_10097((class_2338)blockPos.method_10069(-30, -30, -30), (class_2338)blockPos.method_10069(30, 30, 30))) {
                class_2586 be = this.field_11863.method_8321(pos);
                if (!(be instanceof ThermalBankBlockEntity)) continue;
                ThermalBankBlockEntity blockEntity = (ThermalBankBlockEntity)be;
                sum += blockEntity.getPowerOutput();
            }
        }
        return sum;
    }

    public int getMaxBuffer() {
        int baseMaxBuffer = 100000;
        return baseMaxBuffer + this.getNearbyThermalBankPower();
    }

    public void refreshNearbyPower() {
        this.cachedNearbyPower = this.getNearbyThermalBankPower();
        this.method_5431();
    }

    private int getExtraPower() {
        return this.cachedNearbyPower;
    }

    public int getTotalPower() {
        int basePower = 150;
        return basePower + this.cachedNearbyPower;
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        if (!this.registeredToManager && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            PowerNetworkManager manager = PowerNetworkManager.get(serverWorld);
            manager.registerGenerator(this.method_11016(), () -> {
                try {
                    return this.getTotalPower();
                }
                catch (Throwable t) {
                    return 0;
                }
            });
            this.registeredToManager = true;
        }
    }

    public void method_11012() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            PowerNetworkManager.get(serverWorld).unregisterGenerator(this.method_11016());
        }
        super.method_11012();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> state.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
        PowerNetworkManager manager = PowerNetworkManager.get((class_3218)serverPlayerEntity.method_37908());
        packetByteBuf.writeDouble(manager.getLastSupplyRatio());
        packetByteBuf.writeInt(manager.getLastTotalGenerated());
        packetByteBuf.writeInt(manager.getLastTotalDemand());
        packetByteBuf.writeInt(manager.getCurrentStoredEnergy());
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"blockEntity.protocol_anchor_core");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ProtocolAnchorCoreScreenHandler(syncId, playerInventory, this);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.buffer = nbt.method_10550("buffer");
        class_1262.method_5429((class_2487)nbt, this.inv);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("buffer", this.buffer);
        class_1262.method_5426((class_2487)nbt, this.inv);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public int[] method_5494(class_2350 side) {
        int[] slots = new int[this.inv.size()];
        for (int i = 0; i < this.inv.size(); ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)ProtocolAnchorCoreBlock.FACING);
        return dir == facing;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)ProtocolAnchorCoreBlock.FACING);
        return dir != facing;
    }
}

