/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.pipe;

import com.besson.endfield.blockentity.custom.PipeBlockEntity;
import com.besson.endfield.pipe.PipeAPI;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2586;

public class PipeNetwork {
    private final UUID id;
    private final Set<class_2338> nodes = new HashSet<class_2338>();
    private final SingleVariantStorage<FluidVariant> storage;

    public PipeNetwork(UUID id) {
        this.id = id;
        this.storage = new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return (long)PipeNetwork.this.nodes.size() * 10000L;
            }
        };
    }

    public PipeNetwork() {
        this(UUID.randomUUID());
    }

    public UUID getId() {
        return this.id;
    }

    public void addNode(class_2338 pos) {
        this.nodes.add(pos);
    }

    public void removeNode(class_2338 pos) {
        this.nodes.remove(pos);
    }

    public Set<class_2338> getNodes() {
        return this.nodes;
    }

    public Storage<FluidVariant> getStorage() {
        return this.storage;
    }

    public void tick(class_1937 world) {
        if (world.field_9236) {
            return;
        }
        for (class_2338 pos : this.nodes) {
            class_2586 pipeBe = world.method_8321(pos);
            if (!(pipeBe instanceof PipeBlockEntity)) continue;
            for (class_2350 dir : class_2350.values()) {
                long moved;
                Transaction tx;
                class_2338 neighborPos = pos.method_10093(dir);
                Storage<FluidVariant> neighborStorage = PipeAPI.getNeighborFluidStorage(world, neighborPos, dir.method_10153());
                if (neighborStorage == null || neighborStorage == this.storage) continue;
                if (!this.storage.isResourceBlank() && this.storage.getAmount() > 0L) {
                    tx = Transaction.openOuter();
                    try {
                        moved = StorageUtil.move(this.storage, neighborStorage, v -> true, (long)1000L, (TransactionContext)tx);
                        if (moved > 0L) {
                            tx.commit();
                        }
                    }
                    finally {
                        if (tx != null) {
                            tx.close();
                        }
                    }
                }
                if (this.storage.getAmount() >= this.storage.getCapacity()) continue;
                tx = Transaction.openOuter();
                try {
                    moved = StorageUtil.move(neighborStorage, this.storage, v -> true, (long)1000L, (TransactionContext)tx);
                    if (moved <= 0L) continue;
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
        }
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        for (class_2338 pos : this.nodes) {
            list.add((Object)class_2503.method_23251((long)pos.method_10063()));
        }
        tag.method_10566("nodes", (class_2520)list);
        tag.method_25927("id", this.id);
        tag.method_10566("storage", (class_2520)((FluidVariant)this.storage.variant).toNbt());
        tag.method_10544("amount", this.storage.amount);
        return tag;
    }

    public static PipeNetwork fromNbt(class_2487 tag) {
        PipeNetwork net = new PipeNetwork(tag.method_25926("id"));
        class_2499 list = tag.method_10554("nodes", 4);
        for (int i = 0; i < list.size(); ++i) {
            net.addNode(class_2338.method_10092((long)((class_2503)list.method_10534(i)).method_10699()));
        }
        FluidVariant variant = FluidVariant.fromNbt((class_2487)tag.method_10562("storage"));
        long amount = tag.method_10537("amount");
        if (!variant.isBlank() && amount > 0L) {
            try (Transaction tx = Transaction.openOuter();){
                net.getStorage().insert((Object)variant, amount, (TransactionContext)tx);
                tx.commit();
            }
        }
        return net;
    }
}

