/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.pipe;

import com.besson.endfield.pipe.PipeNetwork;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class PipeNetworkManager
extends class_18 {
    public static final String KEY = "pipe_network_manager";
    private final Map<class_2338, UUID> nodeToNetwork = new HashMap<class_2338, UUID>();
    private final Map<UUID, PipeNetwork> networks = new HashMap<UUID, PipeNetwork>();
    private final class_3218 world;

    public PipeNetworkManager(class_3218 world) {
        this.world = world;
    }

    public static PipeNetworkManager getInstance(class_3218 world) {
        return (PipeNetworkManager)world.method_17983().method_17924(nbt -> PipeNetworkManager.fromNbt(world, nbt), () -> new PipeNetworkManager(world), KEY);
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (Map.Entry<class_2338, UUID> d : this.nodeToNetwork.entrySet()) {
            class_2487 entry = new class_2487();
            entry.method_10544("pos", d.getKey().method_10063());
            entry.method_25927("net", d.getValue());
            list.add((Object)entry);
        }
        nbt.method_10566("nodes", (class_2520)list);
        class_2499 nets = new class_2499();
        for (PipeNetwork network : this.networks.values()) {
            nets.add((Object)network.toNbt());
        }
        nbt.method_10566("networks", (class_2520)nets);
        return nbt;
    }

    public static PipeNetworkManager fromNbt(class_3218 world, class_2487 nbt) {
        PipeNetworkManager manager = new PipeNetworkManager(world);
        class_2499 list = nbt.method_10554("nodes", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 entry = list.method_10602(i);
            class_2338 pos = class_2338.method_10092((long)entry.method_10537("pos"));
            UUID id = entry.method_25926("net");
            manager.nodeToNetwork.put(pos, id);
            manager.networks.computeIfAbsent(id, map -> new PipeNetwork()).addNode(pos);
        }
        class_2499 nets = nbt.method_10554("networks", 10);
        for (int i = 0; i < nets.size(); ++i) {
            PipeNetwork net = PipeNetwork.fromNbt(nets.method_10602(i));
            manager.networks.put(net.getId(), net);
            for (class_2338 pos : net.getNodes()) {
                manager.nodeToNetwork.put(pos, net.getId());
            }
        }
        return manager;
    }

    public void markDirtyAndSave() {
        this.method_80();
        if (this.world != null) {
            this.world.method_17983().method_125();
        }
    }

    public void onPipeAdded(class_1937 world, class_2338 pos) {
        PipeNetwork targetNetwork;
        if (world.field_9236) {
            return;
        }
        HashSet<UUID> adjacentNetworks = new HashSet<UUID>();
        for (class_2350 dir : class_2350.values()) {
            class_2338 neighborPos = pos.method_10093(dir);
            UUID neighborId = this.nodeToNetwork.get(neighborPos);
            if (neighborId == null) continue;
            adjacentNetworks.add(neighborId);
        }
        if (adjacentNetworks.isEmpty()) {
            targetNetwork = new PipeNetwork();
            this.networks.put(targetNetwork.getId(), targetNetwork);
        } else {
            UUID mainId = (UUID)adjacentNetworks.iterator().next();
            targetNetwork = this.networks.get(mainId);
            for (UUID otherId : adjacentNetworks) {
                if (otherId.equals(mainId)) continue;
                this.mergeNetworks(otherId, mainId);
            }
        }
        targetNetwork.addNode(pos);
        this.nodeToNetwork.put(pos, targetNetwork.getId());
        this.markDirtyAndSave();
    }

    public void onPipeRemoved(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return;
        }
        UUID netId = this.nodeToNetwork.remove(pos);
        if (netId == null) {
            return;
        }
        PipeNetwork network = this.networks.get(netId);
        if (network == null) {
            return;
        }
        network.removeNode(pos);
        if (network.getNodes().isEmpty()) {
            this.networks.remove(netId);
            this.markDirtyAndSave();
            return;
        }
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayList<HashSet<class_2338>> subnets = new ArrayList<HashSet<class_2338>>();
        for (class_2338 class_23382 : network.getNodes()) {
            if (visited.contains(class_23382)) continue;
            HashSet<class_2338> subnet = new HashSet<class_2338>();
            this.dfs(class_23382, network.getNodes(), subnet, visited);
            subnets.add(subnet);
        }
        if (subnets.size() > 1) {
            this.networks.remove(netId);
            for (Set set : subnets) {
                PipeNetwork newNet = new PipeNetwork();
                for (class_2338 p : set) {
                    newNet.addNode(p);
                    this.nodeToNetwork.put(p, newNet.getId());
                }
                this.networks.put(newNet.getId(), newNet);
            }
        }
        this.markDirtyAndSave();
    }

    private void dfs(class_2338 start, Set<class_2338> all, Set<class_2338> subnet, Set<class_2338> visited) {
        if (!visited.add(start)) {
            return;
        }
        subnet.add(start);
        for (class_2350 dir : class_2350.values()) {
            class_2338 next = start.method_10093(dir);
            if (!all.contains(next)) continue;
            this.dfs(next, all, subnet, visited);
        }
    }

    private void mergeNetworks(UUID fromId, UUID toId) {
        if (fromId.equals(toId)) {
            return;
        }
        PipeNetwork from = this.networks.remove(fromId);
        PipeNetwork to = this.networks.get(toId);
        if (from == null || to == null) {
            return;
        }
        for (class_2338 node : from.getNodes()) {
            to.addNode(node);
            this.nodeToNetwork.put(node, toId);
        }
        Storage<FluidVariant> fromStorage = from.getStorage();
        Storage<FluidVariant> toStorage = to.getStorage();
        if (fromStorage != null && toStorage != null) {
            try (Transaction tx = Transaction.openOuter();){
                long moved = StorageUtil.move(fromStorage, toStorage, v -> true, (long)Long.MAX_VALUE, (TransactionContext)tx);
                if (moved > 0L) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void tickAllNetworks(class_1937 world) {
        for (PipeNetwork network : this.networks.values()) {
            network.tick(world);
        }
    }
}

