/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockentity.custom;

import com.besson.endfield.blockentity.ImplementedInventory;
import com.besson.endfield.screen.custom.BigStorageScreenHandler;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class BigStorageBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private final Map<ItemVariant, Long> storage = new HashMap<ItemVariant, Long>();
    private final long capacity = 10000L;
    public static final int MAX_SLOTS = 108;
    private final class_2371<class_1799> dummyInventory = class_2371.method_10213((int)108, (Object)class_1799.field_8037);

    public BigStorageBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public Map<ItemVariant, Long> getStorage() {
        return this.storage;
    }

    public boolean insertItem(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        ItemVariant variant = ItemVariant.of((class_1799)stack);
        long existing = this.storage.getOrDefault(variant, 0L);
        if (!this.storage.containsKey(variant) && this.storage.size() >= 108) {
            return false;
        }
        long newCount = existing + (long)stack.method_7947();
        this.storage.put(variant, newCount);
        int index = this.getVariantIndex(variant);
        this.dummyInventory.set(index, (Object)variant.toStack((int)Math.min(newCount, 10000L)));
        stack.method_7934(stack.method_7947());
        this.method_5431();
        return true;
    }

    public class_1799 extractItem(ItemVariant variant, long amount) {
        long existing = this.storage.getOrDefault(variant, 0L);
        if (existing <= 0L) {
            return class_1799.field_8037;
        }
        long toExtract = Math.min(amount, existing);
        this.storage.put(variant, existing - toExtract);
        if (this.storage.get(variant) == 0L) {
            this.storage.remove(variant);
        }
        int index = this.getVariantIndex(variant);
        if (this.storage.containsKey(variant)) {
            this.dummyInventory.set(index, (Object)variant.toStack((int)Math.min(this.storage.get(variant), 64L)));
        } else {
            this.dummyInventory.set(index, (Object)class_1799.field_8037);
        }
        this.method_5431();
        return variant.toStack((int)toExtract);
    }

    private int getVariantIndex(ItemVariant variant) {
        int i = 0;
        for (ItemVariant v : this.storage.keySet()) {
            if (v.equals((Object)variant)) {
                return i;
            }
            if (++i < 108) continue;
            break;
        }
        return 0;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2499 list = new class_2499();
        int count = 0;
        for (Map.Entry<ItemVariant, Long> entry : this.storage.entrySet()) {
            if (count++ >= 108) break;
            class_2487 entryTag = new class_2487();
            entryTag.method_10566("Item", (class_2520)entry.getKey().toNbt());
            entryTag.method_10544("Count", entry.getValue().longValue());
            list.add((Object)entryTag);
        }
        nbt.method_10566("Items", (class_2520)list);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.clear();
        class_2499 list = nbt.method_10554("Items", 10);
        int index = 0;
        for (class_2520 e : list) {
            class_2487 entryTag = (class_2487)e;
            ItemVariant variant = ItemVariant.fromNbt((class_2487)entryTag.method_10562("Item"));
            long count = entryTag.method_10537("Count");
            this.storage.put(variant, count);
            if (index >= 108) continue;
            this.dummyInventory.set(index, (Object)variant.toStack((int)Math.min(count, 64L)));
            ++index;
        }
        for (int i = index; i < 108; ++i) {
            this.dummyInventory.set(i, (Object)class_1799.field_8037);
        }
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"blockEntity.big_storage");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BigStorageScreenHandler(syncId, playerInventory, this);
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.dummyInventory;
    }
}

