/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockentity.custom;

import com.besson.endfield.block.custom.FluidPumpBlock;
import com.besson.endfield.blockentity.ModBlockEntities;
import com.besson.endfield.screen.custom.FluidPumpScreenHandler;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3913;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FluidPumpBlockEntity
extends class_2586
implements GeoBlockEntity,
ExtendedScreenHandlerFactory {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int CAPACITY = 10000;
    private final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 10000L;
        }
    };
    private int pumpCooldown = 0;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> (int)FluidPumpBlockEntity.this.fluidStorage.getAmount();
                case 1 -> (int)FluidPumpBlockEntity.this.fluidStorage.getCapacity();
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return 2;
        }
    };

    public FluidPumpBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.FLUID_PUMP, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, FluidPumpBlockEntity blockEntity) {
        if (world.method_8608()) {
            return;
        }
        ++blockEntity.pumpCooldown;
        if (blockEntity.pumpCooldown % 20 != 0) {
            return;
        }
        class_2338 waterPos = pos.method_10093(blockEntity.getCachedFacing().method_10153()).method_10074();
        class_3610 waterState = world.method_8316(waterPos);
        if (waterState.method_15767(class_3486.field_15517)) {
            try (Transaction tx = Transaction.openOuter();){
                long inserted = blockEntity.fluidStorage.insert((TransferVariant)FluidVariant.of((class_3611)class_3612.field_15910), 1000L, (TransactionContext)tx);
                if (inserted > 0L) {
                    tx.commit();
                }
            }
        }
        blockEntity.pumpCooldown = 0;
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"blockEntity.fluid_pump");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new FluidPumpScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2487 fluidNbt = new class_2487();
        FluidVariant variant = (FluidVariant)this.fluidStorage.getResource();
        fluidNbt.method_10582("fluid", class_7923.field_41173.method_10221((Object)variant.getFluid()).toString());
        fluidNbt.method_10544("amount", this.fluidStorage.getAmount());
        nbt.method_10566("fluidStorage", (class_2520)fluidNbt);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("fluidStorage")) {
            class_2487 fluidNbt = nbt.method_10562("fluidStorage");
            String fluidIdStr = fluidNbt.method_10558("fluid");
            class_3611 fluid = null;
            if (fluidIdStr != null && !fluidIdStr.isEmpty()) {
                try {
                    fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(fluidIdStr));
                }
                catch (Exception e) {
                    fluid = null;
                }
            }
            long amount = fluidNbt.method_10537("amount");
            if (fluid == null || fluid == class_3612.field_15906 || amount <= 0L) {
                try (Transaction tx = Transaction.openOuter();){
                    StorageUtil.move(this.fluidStorage, (Storage)new SingleVariantStorage<FluidVariant>(){

                        protected FluidVariant getBlankVariant() {
                            return FluidVariant.blank();
                        }

                        protected long getCapacity(FluidVariant variant) {
                            return Long.MAX_VALUE;
                        }
                    }, v -> true, (long)Long.MAX_VALUE, (TransactionContext)tx);
                    tx.commit();
                }
                return;
            }
            try (Transaction tx = Transaction.openOuter();){
                StorageUtil.move(this.fluidStorage, (Storage)new SingleVariantStorage<FluidVariant>(){

                    protected FluidVariant getBlankVariant() {
                        return FluidVariant.blank();
                    }

                    protected long getCapacity(FluidVariant variant) {
                        return Long.MAX_VALUE;
                    }
                }, v -> true, (long)Long.MAX_VALUE, (TransactionContext)tx);
                this.fluidStorage.insert((TransferVariant)FluidVariant.of((class_3611)fluid), amount, (TransactionContext)tx);
                tx.commit();
            }
        }
    }

    public Storage<FluidVariant> getFluidStorageForSide(class_2350 side) {
        class_2350 outputSide = this.getCachedFacing();
        if (side == outputSide) {
            return this.fluidStorage;
        }
        return null;
    }

    private class_2350 getCachedFacing() {
        class_2680 state = this.method_10997().method_8320(this.method_11016());
        return (class_2350)state.method_11654((class_2769)FluidPumpBlock.FACING);
    }
}

