/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockEntity.custom;

import com.besson.endfield.blockEntity.ModBlockEntities;
import com.besson.endfield.blockEntity.custom.ThermalBankBlockEntity;
import com.besson.endfield.power.PowerNetworkManager;
import com.besson.endfield.screen.custom.ProtocolAnchorCoreScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ProtocolAnchorCoreBlockEntity
extends BlockEntity
implements GeoBlockEntity,
MenuProvider {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int buffer = 0;
    private int cachedNearbyPower = 0;
    private boolean registeredToManager = false;
    private final ItemStackHandler sideHandler = new ItemStackHandler(54){

        protected void onContentsChanged(int slot) {
            ProtocolAnchorCoreBlockEntity.this.m_6596_();
        }
    };
    private final LazyOptional<IItemHandler> sideLazy = LazyOptional.of(() -> this.sideHandler);

    public ProtocolAnchorCoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PROTOCOL_ANCHOR_CORE.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ProtocolAnchorCoreBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        int totalPower = entity.getTotalPower();
        int newBuffer = Math.min(entity.buffer + totalPower, entity.getMaxBuffer());
        if (newBuffer != entity.buffer) {
            entity.buffer = newBuffer;
            entity.m_6596_();
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82377_(2.0, 27.0, 2.0);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.sideLazy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.sideLazy.invalidate();
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
        if (!this.registeredToManager && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            PowerNetworkManager.get(serverLevel).registerGenerator(this.m_58899_(), () -> {
                try {
                    return this.getTotalPower();
                }
                catch (Throwable t) {
                    return 0;
                }
            });
            this.registeredToManager = true;
        }
    }

    public void m_7651_() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PowerNetworkManager.get(serverLevel).unregisterGenerator(this.m_58899_());
        }
        super.m_7651_();
    }

    private int getNearbyThermalBankPower() {
        int sum = 0;
        BlockPos blockPos = this.m_58899_();
        if (this.f_58857_ != null) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-30, -30, -30), (BlockPos)blockPos.m_7918_(30, 30, 30))) {
                BlockEntity be = this.f_58857_.m_7702_(pos);
                if (!(be instanceof ThermalBankBlockEntity)) continue;
                ThermalBankBlockEntity blockEntity = (ThermalBankBlockEntity)be;
                sum += blockEntity.getPowerOutput();
            }
        }
        return sum;
    }

    public void writeScreenData(FriendlyByteBuf buf) {
        buf.m_130064_(this.f_58858_);
        ServerLevel level = (ServerLevel)this.m_58904_();
        PowerNetworkManager manager = PowerNetworkManager.get(level);
        buf.writeDouble(manager.getLastSupplyRatio());
        buf.writeInt(manager.getLastTotalGenerated());
        buf.writeInt(manager.getLastTotalDemand());
        buf.writeInt(manager.getCurrentStoredEnergy());
    }

    public int getMaxBuffer() {
        int baseMaxBuffer = 100000;
        return baseMaxBuffer + this.getNearbyThermalBankPower();
    }

    public void refreshNearbyPower() {
        this.cachedNearbyPower = this.getNearbyThermalBankPower();
        this.m_6596_();
    }

    private int getExtraPower() {
        return this.cachedNearbyPower;
    }

    public int getTotalPower() {
        int basePower = 150;
        return basePower + this.cachedNearbyPower;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> state.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"blockEntity.protocol_anchor_core");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ProtocolAnchorCoreScreenHandler(pContainerId, pPlayerInventory, this);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("buffer", this.buffer);
        pTag.m_128365_("inventory", (Tag)this.sideHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.buffer = pTag.m_128451_("buffer");
        this.sideHandler.deserializeNBT(pTag.m_128469_("inventory"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.m_122779_();
        for (int i = 0; i < this.sideHandler.getSlots(); ++i) {
            items.add((Object)this.sideHandler.getStackInSlot(i));
        }
        return items;
    }

    public IItemHandler getItemHandler() {
        return this.sideHandler;
    }
}

